package com.aizuda.snailjob.server.service.convert;

import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-09-20T02:57:03+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 17.0.16 (Eclipse Adoptium)"
)
public class WorkflowConverterImpl implements WorkflowConverter {

    @Override
    public WorkflowDetailResponse convert(Workflow workflow) {
        if ( workflow == null ) {
            return null;
        }

        WorkflowDetailResponse workflowDetailResponse = new WorkflowDetailResponse();

        workflowDetailResponse.setId( workflow.getId() );
        workflowDetailResponse.setWorkflowName( workflow.getWorkflowName() );
        workflowDetailResponse.setGroupName( workflow.getGroupName() );
        workflowDetailResponse.setTriggerType( workflow.getTriggerType() );
        workflowDetailResponse.setBlockStrategy( workflow.getBlockStrategy() );
        workflowDetailResponse.setExecutorTimeout( workflow.getExecutorTimeout() );
        workflowDetailResponse.setWorkflowStatus( workflow.getWorkflowStatus() );
        workflowDetailResponse.setWfContext( workflow.getWfContext() );

        workflowDetailResponse.setNotifyIds( WorkflowConverter.toNotifyIds(workflow.getNotifyIds()) );
        workflowDetailResponse.setTriggerInterval( WorkflowConverter.toTriggerInterval(workflow) );
        workflowDetailResponse.setOwnerId( WorkflowConverter.getOwnerId(workflow) );

        return workflowDetailResponse;
    }

    @Override
    public void fillCommonFields(Workflow workflow, WorkflowDetailResponse target) {
        if ( workflow == null ) {
            return;
        }

        target.setId( workflow.getId() );
        target.setWorkflowName( workflow.getWorkflowName() );
        target.setGroupName( workflow.getGroupName() );
        target.setTriggerType( workflow.getTriggerType() );
        target.setBlockStrategy( workflow.getBlockStrategy() );
        target.setExecutorTimeout( workflow.getExecutorTimeout() );
        target.setWorkflowStatus( workflow.getWorkflowStatus() );
        target.setWfContext( workflow.getWfContext() );

        target.setNotifyIds( WorkflowConverter.toNotifyIds(workflow.getNotifyIds()) );
        target.setTriggerInterval( WorkflowConverter.toTriggerInterval(workflow) );
        target.setOwnerId( WorkflowConverter.getOwnerId(workflow) );
    }

    @Override
    public List<WorkflowDetailResponse.NodeInfo> convertList(List<WorkflowNode> workflowNodes) {
        if ( workflowNodes == null ) {
            return null;
        }

        List<WorkflowDetailResponse.NodeInfo> list = new ArrayList<WorkflowDetailResponse.NodeInfo>( workflowNodes.size() );
        for ( WorkflowNode workflowNode : workflowNodes ) {
            list.add( convert( workflowNode ) );
        }

        return list;
    }

    @Override
    public WorkflowDetailResponse.NodeInfo convert(WorkflowNode workflowNode) {
        if ( workflowNode == null ) {
            return null;
        }

        WorkflowDetailResponse.NodeInfo nodeInfo = new WorkflowDetailResponse.NodeInfo();

        nodeInfo.setId( workflowNode.getId() );
        nodeInfo.setNodeType( workflowNode.getNodeType() );
        nodeInfo.setNodeName( workflowNode.getNodeName() );
        nodeInfo.setPriorityLevel( workflowNode.getPriorityLevel() );
        nodeInfo.setWorkflowNodeStatus( workflowNode.getWorkflowNodeStatus() );
        nodeInfo.setFailStrategy( workflowNode.getFailStrategy() );

        nodeInfo.setDecision( WorkflowConverter.parseDecisionConfig(workflowNode) );
        nodeInfo.setJobTask( WorkflowConverter.parseJobTaskConfig(workflowNode) );

        return nodeInfo;
    }
}
