package com.aizuda.snailjob.template.datasource.persistence.po;

import com.aizuda.snailjob.common.core.enums.ExecutorTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.JdbcType;

/**
 * 任务信息
 *
 * @author opensnail
 * @since 2023-09-24
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("sj_job")
public class Job extends CreateUpdateDt {

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 命名空间id
     */
    private String namespaceId;

    /**
     * 组名称
     */
    private String groupName;

    /**
     * 名称
     */
    @TableField(updateStrategy =  FieldStrategy.NOT_EMPTY)
    private String jobName;

    /**
     * 执行方法参数
     */
    @TableField(updateStrategy =  FieldStrategy.NOT_EMPTY)
    private String argsStr;

    /**
     * 参数类型 text/json
     */
    @TableField(updateStrategy =  FieldStrategy.NOT_EMPTY)
    private Integer argsType;

    /**
     * 扩展字段
     */
    @TableField(updateStrategy =  FieldStrategy.NOT_EMPTY)
    private String extAttrs;

    /**
     * 下次触发时间
     */
    private Long nextTriggerAt;

    /**
     * 重试状态 0、关闭、1、开启
     * {@link StatusEnum}
     */
    private Integer jobStatus;

    /**
     * 执行器路由策略
     */
    private Integer routeKey;

    /**
     * 执行器类型 1、Java
     * {@link ExecutorTypeEnum}
     */
    private Integer executorType;

    /**
     * 执行器信息
     */
    private String executorInfo;

    /**
     * 触发类型 1.CRON 表达式 2. 固定时间
     */
    private Integer triggerType;

    /**
     * 间隔时长
     */
    @TableField(updateStrategy =  FieldStrategy.NOT_EMPTY)
    private String triggerInterval;

    /**
     * 阻塞策略 1、丢弃 2、覆盖 3、并行
     */
    private Integer blockStrategy;

    /**
     * 任务执行超时时间，单位秒
     */
    private Integer executorTimeout;

    /**
     * 最大重试次数
     */
    private Integer maxRetryTimes;

    /**
     * 重试间隔(s)
     */
    private Integer retryInterval;

    /**
     * 任务类型
     * {@link JobTaskTypeEnum}
     */
    private Integer taskType;

    /**
     * 并行数
     */
    private Integer parallelNum;

    /**
     * bucket
     */
    private Integer bucketIndex;

    /**
     * 是否是常驻任务
     */
    private Integer resident;

    /**
     * 描述
     */
    private String description;

    /**
     * 逻辑删除 1、删除
     */
    private Integer deleted;

    /**
     * 通知告警场景配置id列表
     */
    private String notifyIds;

    /**
     * 负责人id
     */
    private Long ownerId;

    /**
     * 标签
     * json格式，如：{"key1":"value1","key2":"value2"}
     */
    @TableField(updateStrategy =  FieldStrategy.NOT_EMPTY)
    private String labels;

}
