/*
 * Decompiled with CFR 0.152.
 */
package cn.spatiotemporal.commons.util;

import cn.hutool.system.oshi.OshiUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import oshi.hardware.NetworkIF;

public class IpUtil {
    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getEthIp4(String ip) {
        String ethip = ip;
        List networkIFs = OshiUtil.getNetworkIFs();
        for (NetworkIF networkIF : networkIFs) {
            String[] iPv4addr;
            if (!networkIF.getName().startsWith("eth") && !networkIF.getName().startsWith("en") || null == (iPv4addr = networkIF.getIPv4addr()) || iPv4addr.length <= 0) continue;
            ethip = iPv4addr[0];
            return ethip;
        }
        return ethip;
    }
}

