package cn.spatiotemporal.commons.config;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;

import cn.spatiotemporal.commons.constant.RegisterConstants;
import cn.spatiotemporal.commons.util.IpUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @ClassName: EnableServerCorn    
 * @Description: 服务配置
 * @date 2023年8月29日 下午5:24:27    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
 */
@Slf4j
public class EnableServerCorn {

	/**
	 * 服务端口
	 */
	@Value("${server.port}")
	private String port;
	
	@Value("${server.name}")
	private String serveName;
	
	@Value("${server.servlet.context-path}")
	private String contextPath;
	
	public Integer getPeriod() {
		return period;
	}

	public void setPeriod(Integer period) {
		this.period = period;
	}

	/**
	 * 轮询时间 = period 过期时间=period+5
	 */
	private Integer period;

	/**
	 * 本机ip
	 */
	private String ip = IpUtil.getEthIp4("127.0.0.1");

	@Resource
	RedisTemplate<String, Object> redisTemplate;

	@PostConstruct
	public void initMethod() {
		if (redisTemplate == null) {
			log.error("redisTemplate在容器中不存在");
			throw new RuntimeException();
		}
		// 获取间隔时间
		if (period == null) {
			period = 30;
		}

		if (!ip.equals("127.0.0.1")) {
			String key = RegisterConstants.SERVICE_REGISTER_KEY + serveName + ":" + ip + ":" + port + contextPath;
			
			ThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(serveName + "_Thread-%d").build();
			Executors.newSingleThreadScheduledExecutor(threadFactory).scheduleAtFixedRate(() -> {
				try {
					boolean exist = redisTemplate.opsForValue().setIfAbsent(key, "", period + 5, TimeUnit.SECONDS);
					if (!exist)
						redisTemplate.expire(key, period + 5, TimeUnit.SECONDS);
					log.debug("===== {} 服务续期 ====", key);
				}catch(Exception ex) {
					log.error(serveName + "服务注册发生错误！", ex);
				}
		
			}, 5, period, TimeUnit.SECONDS);
			log.info("========== ‘{}’ 服务注册. ==========", serveName);			
		} else {
			log.warn("服务：{}所在主机IP：{}获取无效，服务无法注册！", serveName, ip);
		}
	}

	public EnableServerCorn() {
	}
}
