/*
 * Decompiled with CFR 0.152.
 */
package cn.spatiotemporal.commons.config;

import cn.spatiotemporal.commons.constant.RegisterConstants;
import cn.spatiotemporal.commons.util.IpUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;

public class EnableServerCorn {
    private static final Logger log = LoggerFactory.getLogger(EnableServerCorn.class);
    @Value(value="${server.port}")
    private String port;
    @Value(value="${server.name}")
    private String serveName;
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    private Integer period;
    private String ip = IpUtil.getEthIp4("127.0.0.1");
    @Resource
    RedisTemplate<String, Object> redisTemplate;

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    @PostConstruct
    public void initMethod() {
        if (this.redisTemplate == null) {
            log.error("redisTemplate\u5728\u5bb9\u5668\u4e2d\u4e0d\u5b58\u5728");
            throw new RuntimeException();
        }
        if (this.period == null) {
            this.period = 30;
        }
        if (!this.ip.equals("127.0.0.1")) {
            String key = RegisterConstants.SERVICE_REGISTER_KEY + this.serveName + ":" + this.ip + ":" + this.port + this.contextPath;
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(this.serveName + "_Thread-%d").build();
            Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory).scheduleAtFixedRate(() -> {
                try {
                    boolean exist = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"", (long)(this.period + 5), TimeUnit.SECONDS);
                    if (!exist) {
                        this.redisTemplate.expire((Object)key, (long)(this.period + 5), TimeUnit.SECONDS);
                    }
                    log.debug("===== {} \u670d\u52a1\u7eed\u671f ====", (Object)key);
                }
                catch (Exception ex) {
                    log.error(this.serveName + "\u670d\u52a1\u6ce8\u518c\u53d1\u751f\u9519\u8bef\uff01", (Throwable)ex);
                }
            }, 5L, this.period.intValue(), TimeUnit.SECONDS);
            log.info("========== \u2018{}\u2019 \u670d\u52a1\u6ce8\u518c. ==========", (Object)this.serveName);
        } else {
            log.warn("\u670d\u52a1\uff1a{}\u6240\u5728\u4e3b\u673aIP\uff1a{}\u83b7\u53d6\u65e0\u6548\uff0c\u670d\u52a1\u65e0\u6cd5\u6ce8\u518c\uff01", (Object)this.serveName, (Object)this.ip);
        }
    }
}

