/*
 * Decompiled with CFR 0.152.
 */
package cn.spatiotemporal.commons.file.util;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger log = LoggerFactory.getLogger(FtpUtil.class);
    private static final int FTP_TIMEOUT = 30000;
    public static final int FTP_OK = 0;
    public static final int FTP_CONNECT_ERROR = -1;
    public static final int FTP_LOGIN_ERROR = -2;
    public static final int FTP_LOCAL_FILE_ERROR = -3;
    public static final int FTP_LOGOUT_ERROR = -4;
    public static final int FTP_TRANSFER_ERROR = -9;
    public static final int FTP_NO_FILE_TRANSFER = 99;

    public static int ftpPutFile(String _strHost, String _strPort, String _strFtpUser, String _strFtpPwd, String[] _strSrcFiles) {
        return FtpUtil.ftpPutFile(_strHost, _strPort, _strFtpUser, _strFtpPwd, _strSrcFiles, "");
    }

    public static int ftpPutFile(String _strHost, String _strPort, String _strFtpUser, String _strFtpPwd, String[] _strSrcFiles, String _strEntryDesDir) {
        int iRtn = 99;
        log.info("ip=" + _strHost + ", port=" + _strPort + ", user=" + _strFtpUser + ", passwd=" + _strFtpPwd + ", files=" + _strSrcFiles.length + ", entryDir=" + _strEntryDesDir);
        String strfilename = "";
        if (_strSrcFiles.length <= 0) {
            return iRtn;
        }
        FTPClient ftp = null;
        try {
            String[] strDirs;
            iRtn = -1;
            ftp = new FTPClient();
            ftp.setRemoteHost(_strHost);
            ftp.setRemotePort(Integer.parseInt(_strPort));
            ftp.setTimeout(30000);
            ftp.connect();
            iRtn = -2;
            ftp.login(_strFtpUser, _strFtpPwd);
            log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
            ftp.setType(FTPTransferType.BINARY);
            if (_strEntryDesDir.trim().length() > 0 && (strDirs = _strEntryDesDir.split("/", -1)) != null) {
                String strCurDir = "";
                for (int i = 0; i < strDirs.length; ++i) {
                    strCurDir = strCurDir.length() > 0 ? strCurDir + "/" + strDirs[i] : strDirs[i];
                    try {
                        ftp.mkdir(strDirs[i]);
                        log.info("Create Dir : " + strCurDir + " OK!");
                    }
                    catch (FTPException fTPException) {
                        // empty catch block
                    }
                    ftp.chdir(strDirs[i]);
                }
                log.info("Change Dir : " + strCurDir + " OK!");
            }
            ftp.setConnectMode(FTPConnectMode.PASV);
            for (int i = 0; i < _strSrcFiles.length; ++i) {
                if (_strSrcFiles[i].length() <= 0) continue;
                if (!FtpUtil.dirIsExist(_strSrcFiles[i])) {
                    iRtn = -3;
                    throw new IOException(_strSrcFiles[i] + " : not such file!");
                }
                int index = _strSrcFiles[i].lastIndexOf(File.separator);
                strfilename = _strSrcFiles[i].substring(index + 1);
                iRtn = -9;
                ftp.put(_strSrcFiles[i], strfilename);
                log.info("Put file " + _strSrcFiles[i] + " OK!");
            }
            iRtn = -4;
            ftp.quit();
            log.info("Logout!\n");
            iRtn = 0;
        }
        catch (FTPException ex) {
            log.error("ftpPutFile : " + ex.getMessage());
        }
        catch (IOException ex1) {
            log.error("ftpPutFile : " + ex1.getMessage());
        }
        catch (NumberFormatException ex2) {
            log.error("ftpPutFile : " + ex2.getMessage());
        }
        log.info("ftpFile end. iRtn = " + iRtn);
        return iRtn;
    }

    public static boolean dirIsExist(String _strDir) {
        File dir = new File(_strDir);
        return dir.exists();
    }

    public static List ftpGetFileNameList(String _strHost, String _strPort, String _strFtpUser, String _strFtpPwd, String _strEntryDesDir, String _strFileName) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        log.info("ip=" + _strHost + ", port=" + _strPort + ", user=" + _strFtpUser + ", passwd=" + _strFtpPwd + ", entryDir=" + _strEntryDesDir + ", file=" + _strFileName);
        if (_strFileName == null) {
            return null;
        }
        FTPClient ftp = null;
        try {
            ftp = new FTPClient();
            ftp.setRemoteHost(_strHost);
            ftp.setRemotePort(Integer.parseInt(_strPort));
            ftp.setTimeout(30000);
            ftp.connect();
            ftp.login(_strFtpUser, _strFtpPwd);
            log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
            ftp.setType(FTPTransferType.BINARY);
            if (_strEntryDesDir.trim().length() > 0 && !_strEntryDesDir.trim().equals(".")) {
                if (_strEntryDesDir.substring(0, 1).equals("/")) {
                    ftp.chdir(_strEntryDesDir.trim());
                    log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
                } else {
                    String[] strDirs = _strEntryDesDir.split("/", -1);
                    if (strDirs != null) {
                        String strCurDir = "";
                        for (int i = 0; i < strDirs.length; ++i) {
                            strCurDir = strCurDir.length() > 0 ? strCurDir + "/" + strDirs[i] : strDirs[i];
                            try {
                                ftp.mkdir(strDirs[i]);
                                log.info("Create Dir : " + strCurDir + " OK!");
                            }
                            catch (FTPException fTPException) {
                                // empty catch block
                            }
                            ftp.chdir(strDirs[i]);
                        }
                        log.info("Change Dir : " + strCurDir + " OK!");
                    }
                }
            }
            ftp.setConnectMode(FTPConnectMode.PASV);
            String[] remortFileNames = ftp.dir(_strFileName + "*");
            for (int i = 0; i < remortFileNames.length; ++i) {
                String fileName = remortFileNames[i];
                fileNameList.add(fileName);
            }
            ftp.quit();
            log.info("Logout!\n");
        }
        catch (FTPException ex) {
            if (ex.getMessage().indexOf("No such file") >= 0) {
                return fileNameList;
            }
            if (ex.getMessage().indexOf("Bad directory") >= 0) {
                return fileNameList;
            }
            if (ex.getMessage().indexOf("Unexpected null reply received") >= 0) {
                return fileNameList;
            }
            log.info("ftpGetFileNameList :" + ex.getMessage());
            return null;
        }
        catch (IOException ex1) {
            log.info("ftpGetFileNameList :" + ex1.getMessage());
            return null;
        }
        catch (NumberFormatException ex2) {
            log.info("ftpGetFileNameList :" + ex2.getMessage());
            return null;
        }
        log.info("ftpGetFileNameList end. get filenames num=" + fileNameList.size());
        return fileNameList;
    }

    public static List ftpGetDirList(String _strHost, String _strPort, String _strFtpUser, String _strFtpPwd, String _strEntryDesDir) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        log.info("ip=" + _strHost + ", port=" + _strPort + ", user=" + _strFtpUser + ", passwd=" + _strFtpPwd + ", entryDir=" + _strEntryDesDir);
        FTPClient ftp = null;
        try {
            int i;
            ftp = new FTPClient();
            ftp.setRemoteHost(_strHost);
            ftp.setRemotePort(Integer.parseInt(_strPort));
            ftp.setTimeout(30000);
            ftp.connect();
            ftp.login(_strFtpUser, _strFtpPwd);
            log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
            ftp.setType(FTPTransferType.BINARY);
            if (_strEntryDesDir.trim().length() > 0 && !_strEntryDesDir.trim().equals(".")) {
                if (_strEntryDesDir.substring(0, 1).equals("/")) {
                    ftp.chdir(_strEntryDesDir.trim());
                    log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
                } else {
                    String[] strDirs = _strEntryDesDir.split("/", -1);
                    if (strDirs != null) {
                        String strCurDir = "";
                        for (i = 0; i < strDirs.length; ++i) {
                            strCurDir = strCurDir.length() > 0 ? strCurDir + "/" + strDirs[i] : strDirs[i];
                            try {
                                ftp.mkdir(strDirs[i]);
                                log.info("Create Dir : " + strCurDir + " OK!");
                            }
                            catch (FTPException fTPException) {
                                // empty catch block
                            }
                            ftp.chdir(strDirs[i]);
                        }
                        log.info("Change Dir : " + strCurDir + " OK!");
                    }
                }
            }
            ftp.setConnectMode(FTPConnectMode.PASV);
            String[] remortFileNames = ftp.dir(".", true);
            String[] remortFileNameList = ftp.dir();
            for (i = 0; i < remortFileNames.length; ++i) {
                String fileName = remortFileNames[i];
                if (!FtpUtil.isDir(fileName)) continue;
                fileNameList.add(remortFileNameList[i]);
            }
            ftp.quit();
            log.info("Logout!\n");
        }
        catch (FTPException ex) {
            if (ex.getMessage().indexOf("No such file") >= 0) {
                return fileNameList;
            }
            if (ex.getMessage().indexOf("Bad directory") >= 0) {
                return fileNameList;
            }
            if (ex.getMessage().indexOf("Unexpected null reply received") >= 0) {
                return fileNameList;
            }
            log.info("ftpGetDirList :" + ex.getMessage());
            return null;
        }
        catch (IOException ex1) {
            log.info("ftpGetDirList :" + ex1.getMessage());
            return null;
        }
        catch (NumberFormatException ex2) {
            log.info("ftpGetDirList :" + ex2.getMessage());
            return null;
        }
        log.info("ftpGetDirList end. get dirnames num=" + fileNameList.size());
        return fileNameList;
    }

    private static boolean isDir(String remortFileName) {
        boolean flag = false;
        if ("d".equals(remortFileName.substring(0, 1))) {
            flag = true;
        }
        return flag;
    }

    public static int ftpDeleteFile(String _strHost, String _strPort, String _strFtpUser, String _strFtpPwd, String _strEntryDesDir, String[] _strFileNames) {
        int iRtn = 99;
        if (_strFileNames.length <= 0) {
            return 0;
        }
        FTPClient ftp = null;
        try {
            ftp = new FTPClient();
            ftp.setRemoteHost(_strHost);
            ftp.setRemotePort(Integer.parseInt(_strPort));
            ftp.setTimeout(30000);
            ftp.connect();
            ftp.login(_strFtpUser, _strFtpPwd);
            log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
            ftp.setType(FTPTransferType.BINARY);
            ftp.setConnectMode(FTPConnectMode.PASV);
            if (_strEntryDesDir.trim().length() > 0) {
                if (_strEntryDesDir.substring(0, 1).equals("/")) {
                    ftp.chdir(_strEntryDesDir.trim());
                    log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
                } else {
                    String[] strDirs = _strEntryDesDir.split("/", -1);
                    if (strDirs != null) {
                        String strCurDir = "";
                        for (int i = 0; i < strDirs.length; ++i) {
                            strCurDir = strCurDir.length() > 0 ? strCurDir + "/" + strDirs[i] : strDirs[i];
                            ftp.chdir(strDirs[i]);
                        }
                        log.info("Change Dir : " + strCurDir + " OK!");
                    }
                }
            }
            for (int i = 0; i < _strFileNames.length; ++i) {
                if (_strFileNames[i].length() <= 0) continue;
                try {
                    ftp.delete(_strFileNames[i]);
                    log.info("Delete file " + _strFileNames[i] + " OK!");
                    continue;
                }
                catch (FTPException ex1) {
                    log.info("Delete file " + _strFileNames[i] + " FAIL!" + ex1.getMessage());
                    continue;
                }
                catch (IOException ex1) {
                    log.info("Delete file " + _strFileNames[i] + " FAIL!" + ex1.getMessage());
                }
            }
            iRtn = -4;
            ftp.quit();
            log.info("Logout!\n");
        }
        catch (FTPException ex) {
            log.info("ftpDeleteFile : " + ex.getMessage());
            return -1;
        }
        catch (IOException ex1) {
            log.info("ftpDeleteFile : " + ex1.getMessage());
            return -2;
        }
        catch (NumberFormatException ex2) {
            log.info("ftpDeleteFile : " + ex2.getMessage());
            return -3;
        }
        return 0;
    }

    public static int ftpRenameFile(String _strHost, String _strPort, String _strFtpUser, String _strFtpPwd, String _strEntryDir, String[] _strEntrySrcFilePaths, String[] _strEntryDesFilePaths) {
        int iRtn = 99;
        if (_strEntrySrcFilePaths.length <= 0) {
            return 0;
        }
        if (_strEntryDesFilePaths.length <= 0) {
            return 0;
        }
        FTPClient ftp = null;
        try {
            String[] strDirs;
            iRtn = -1;
            ftp = new FTPClient();
            ftp.setRemoteHost(_strHost);
            ftp.setRemotePort(Integer.parseInt(_strPort));
            ftp.setTimeout(30000);
            ftp.connect();
            iRtn = -2;
            ftp.login(_strFtpUser, _strFtpPwd);
            log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
            ftp.setType(FTPTransferType.BINARY);
            ftp.setConnectMode(FTPConnectMode.PASV);
            if (_strEntryDir.trim().length() > 0 && (strDirs = _strEntryDir.split("/", -1)) != null) {
                String strCurDir = "";
                for (int i = 0; i < strDirs.length; ++i) {
                    strCurDir = strCurDir.length() > 0 ? strCurDir + "/" + strDirs[i] : strDirs[i];
                    ftp.chdir(strDirs[i]);
                }
                log.info("Change Dir : " + strCurDir + " OK!");
            }
            for (int i = 0; i < _strEntrySrcFilePaths.length; ++i) {
                if (_strEntrySrcFilePaths[i].length() <= 0 || _strEntryDesFilePaths[i].length() <= 0) continue;
                String[] strDirs2 = _strEntryDesFilePaths[i].split("/", -1);
                if (strDirs2 != null) {
                    String strDesDir = "";
                    for (int j = 0; j < strDirs2.length - 1; ++j) {
                        strDesDir = j == 0 ? strDesDir + strDirs2[j] : strDesDir + "/" + strDirs2[j];
                        try {
                            ftp.mkdir(strDesDir);
                            log.info("Create Dir : " + strDesDir + " OK!");
                            continue;
                        }
                        catch (FTPException fTPException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    iRtn = -9;
                    ftp.rename(_strEntrySrcFilePaths[i], _strEntryDesFilePaths[i]);
                    log.info("Rename file " + _strEntrySrcFilePaths[i] + " to " + _strEntryDesFilePaths[i] + " OK!");
                    continue;
                }
                catch (FTPException ex1) {
                    log.error("Rename file " + _strEntrySrcFilePaths[i] + " to " + _strEntryDesFilePaths[i] + " FAIL! " + ex1.getMessage());
                    continue;
                }
                catch (IOException ex1) {
                    log.error("Rename file " + _strEntrySrcFilePaths[i] + " to " + _strEntryDesFilePaths[i] + " FAIL! b" + ex1.getMessage());
                }
            }
            iRtn = -4;
            ftp.quit();
            iRtn = 0;
            log.info("Logout!\n");
        }
        catch (FTPException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (NumberFormatException ex2) {
            log.error(ex2.getMessage(), (Throwable)ex2);
            ex2.printStackTrace();
        }
        return iRtn;
    }
}

