/*
 * Decompiled with CFR 0.152.
 */
package cn.spatiotemporal.commons.file.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.spatiotemporal.commons.file.service.FileService;
import cn.spatiotemporal.commons.file.support.MinioUploadCondition;
import cn.spatiotemporal.commons.file.vo.FileInfo;
import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.http.Method;
import java.io.InputStream;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="uploadFileServiceMinIo")
@Conditional(value={MinioUploadCondition.class})
@ConfigurationProperties(prefix="uploadservice.minio")
public class MinioServiceImpl
implements FileService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MinioServiceImpl.class);
    private String endpoint;
    private String accessKey;
    private String secretKey;
    private String bucketName;
    private String customDomain;
    private MinioClient minioClient;

    public void afterPropertiesSet() {
        log.info("MinIO Client init...");
        Assert.notBlank((CharSequence)this.endpoint, (String)"MinIO endpoint can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.accessKey, (String)"MinIO accessKey can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.secretKey, (String)"MinIO secretKey can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.bucketName, (String)"MinIO bucketName can not be null", (Object[])new Object[0]);
        this.minioClient = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
    }

    @Override
    public FileInfo uploadFile(MultipartFile file) {
        this.createBucketIfAbsent(this.bucketName);
        String suffix = FileUtil.getSuffix((String)file.getOriginalFilename());
        String uuid = IdUtil.simpleUUID();
        String fileName = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy/MM/dd") + "/" + uuid + "." + suffix;
        InputStream inputStream = file.getInputStream();
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(fileName)).contentType(file.getContentType()).stream(inputStream, (long)inputStream.available(), -1L).build();
        this.minioClient.putObject(putObjectArgs);
        if (StrUtil.isBlank((CharSequence)this.customDomain)) {
            GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.bucketName)).object(fileName)).method(Method.GET).build();
            String fileUrl = this.minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
            fileUrl = fileUrl.substring(0, fileUrl.indexOf("?"));
        } else {
            String fileUrl = this.customDomain + '/' + this.bucketName + "/" + fileName;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setName(uuid + "." + suffix);
        fileInfo.setUrl("/" + this.bucketName + "/" + fileName);
        fileInfo.setType(file.getContentType());
        fileInfo.setSize(file.getSize());
        fileInfo.setOriginalName(file.getOriginalFilename());
        return fileInfo;
    }

    @Override
    public boolean deleteFile(String filePath) {
        Assert.notBlank((CharSequence)filePath, (String)"\u5220\u9664\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tempStr = "/" + this.bucketName + "/";
        String fileName = filePath.substring(filePath.indexOf(tempStr) + tempStr.length());
        RemoveObjectArgs removeObjectArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(fileName)).build();
        this.minioClient.removeObject(removeObjectArgs);
        return true;
    }

    private static String publicBucketPolicy(String bucketName) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:ListBucketMultipartUploads\",\"s3:GetBucketLocation\",\"s3:ListBucket\"],\"Resource\":[\"arn:aws:s3:::" + bucketName + "\"]},{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:ListMultipartUploadParts\",\"s3:PutObject\",\"s3:AbortMultipartUpload\",\"s3:DeleteObject\",\"s3:GetObject\"],\"Resource\":[\"arn:aws:s3:::" + bucketName + "/*\"]}]}");
        return builder.toString();
    }

    private void createBucketIfAbsent(String bucketName) {
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build();
        if (!this.minioClient.bucketExists(bucketExistsArgs)) {
            MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build();
            this.minioClient.makeBucket(makeBucketArgs);
            SetBucketPolicyArgs setBucketPolicyArgs = (SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(MinioServiceImpl.publicBucketPolicy(bucketName)).build();
            this.minioClient.setBucketPolicy(setBucketPolicyArgs);
        }
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCustomDomain(String customDomain) {
        this.customDomain = customDomain;
    }
}

