/*
 * Decompiled with CFR 0.152.
 */
package cn.spatiotemporal.commons.file.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.spatiotemporal.commons.file.service.FileService;
import cn.spatiotemporal.commons.file.support.FtpUploadCondition;
import cn.spatiotemporal.commons.file.util.FtpUtil;
import cn.spatiotemporal.commons.file.vo.FileInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.LocalDateTime;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;
import org.springframework.web.multipart.MultipartFile;

@Component(value="uploadFileServiceFtp")
@Conditional(value={FtpUploadCondition.class})
@ConfigurationProperties(prefix="uploadservice.ftp")
public class FtpServiceImpl
implements FileService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FtpServiceImpl.class);
    private String host;
    private String port;
    private String userName;
    private String password;
    private String requestDir;
    private String customDomain;
    private static String UPLOADED_FOLDER = FtpServiceImpl.getLocalStaticPath() + File.separator;

    public void afterPropertiesSet() {
        log.info("Ftp Client init...");
        Assert.notBlank((CharSequence)this.host, (String)"Ftp hot can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.port, (String)"Ftp port can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.userName, (String)"Ftp userName can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.password, (String)"Ftp password can not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.requestDir, (String)"Ftp requestDir can not be null", (Object[])new Object[0]);
    }

    @Override
    public FileInfo uploadFile(MultipartFile file) {
        String suffix = FileUtil.getSuffix((String)file.getOriginalFilename());
        String uuid = IdUtil.simpleUUID();
        String location = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy/MM/dd");
        String fileName = uuid + "." + suffix;
        String localLocation = location.replaceAll("\\/", "\\" + File.separator);
        File uploadOutFile = new File(UPLOADED_FOLDER + localLocation);
        if (!uploadOutFile.exists()) {
            uploadOutFile.mkdirs();
        }
        String outputFile = uploadOutFile.getAbsolutePath() + File.separator + fileName;
        InputStream inputStream = file.getInputStream();
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(outputFile));
        FtpUtil.ftpPutFile(this.host, this.port, this.userName, this.password, new String[]{outputFile}, this.requestDir + "/" + location);
        FileUtils.deleteQuietly((File)new File(outputFile));
        if (StrUtil.isBlank((CharSequence)this.customDomain)) {
            String fileUrl = String.format("ftp://%s:%s/%s/%s", this.host, this.port, location, fileName);
        } else {
            String fileUrl = String.format("%s/%s/s", this.customDomain, location, fileName);
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setName(fileName);
        fileInfo.setUrl("/" + this.requestDir + "/" + location + "/" + fileName);
        fileInfo.setType(file.getContentType());
        fileInfo.setSize(file.getSize());
        fileInfo.setOriginalName(file.getOriginalFilename());
        return fileInfo;
    }

    @Override
    public boolean deleteFile(String filePath) {
        Assert.notBlank((CharSequence)filePath, (String)"\u5220\u9664\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String fileSignimgPath = filePath.substring(0, filePath.lastIndexOf("/"));
        String overFileSignimgName = filePath.substring(filePath.lastIndexOf("/") + 1);
        return FtpUtil.ftpDeleteFile(this.host, this.port, this.userName, this.password, fileSignimgPath, new String[]{overFileSignimgName}) == 0;
    }

    private static String getLocalStaticPath() {
        File upload;
        File path = null;
        try {
            path = new File(ResourceUtils.getURL((String)"classpath:").getPath());
        }
        catch (FileNotFoundException e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u6839\u76ee\u5f55\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        if (!path.exists()) {
            path = new File("");
        }
        if (!(upload = new File(path.getAbsolutePath(), "static")).exists()) {
            upload.mkdirs();
        }
        return upload.getAbsolutePath();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRequestDir(String requestDir) {
        this.requestDir = requestDir;
    }

    public void setCustomDomain(String customDomain) {
        this.customDomain = customDomain;
    }
}

