package cn.spatiotemporal.commons.file.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.enterprisedt.net.ftp.*;

import lombok.extern.slf4j.Slf4j;
/**
 * 
 * @ClassName: FtpUtil    
 * @Description: ftp工具类
 * @date 2018年10月16日 下午3:18:28    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.7
 */
@Slf4j
public class FtpUtil {

	private static final int FTP_TIMEOUT = 30000;

	public static final int FTP_OK = 0;

	public static final int FTP_CONNECT_ERROR = -1;

	public static final int FTP_LOGIN_ERROR = -2;

	public static final int FTP_LOCAL_FILE_ERROR = -3;
	
	public static final int FTP_LOGOUT_ERROR = -4;

	public static final int FTP_TRANSFER_ERROR = -9;
	
	public static final int FTP_NO_FILE_TRANSFER = 99;
	
	public static int ftpPutFile(String _strHost, String _strPort,
			String _strFtpUser, String _strFtpPwd, String[] _strSrcFiles) {
		return ftpPutFile(_strHost, _strPort, _strFtpUser, _strFtpPwd,
				_strSrcFiles, "");
	}

	public static int ftpPutFile(String _strHost, String _strPort,
			String _strFtpUser, String _strFtpPwd, String[] _strSrcFiles,
			String _strEntryDesDir) {
		int iRtn = FTP_NO_FILE_TRANSFER;
		log.info("ip=" + _strHost + ", port=" + _strPort + ", user="
				+ _strFtpUser + ", passwd=" + _strFtpPwd + ", files="
				+ _strSrcFiles.length + ", entryDir=" + _strEntryDesDir);
		String strfilename = "";
		if (_strSrcFiles.length <= 0) {
			return iRtn;
		}

		FTPClient ftp = null;

		try {
			iRtn = FTP_CONNECT_ERROR;
			ftp = new FTPClient();
			ftp.setRemoteHost(_strHost);
			ftp.setRemotePort(Integer.parseInt(_strPort));
			ftp.setTimeout(FTP_TIMEOUT);
			ftp.connect();
			iRtn = FTP_LOGIN_ERROR;
			ftp.login(_strFtpUser, _strFtpPwd);
			log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
			ftp.setType(FTPTransferType.BINARY);
			if (_strEntryDesDir.trim().length() > 0) {
				String[] strDirs = _strEntryDesDir.split("/", -1);
				if (strDirs != null) {
					String strCurDir = "";
					for (int i = 0; i < strDirs.length; i++) {
						if (strCurDir.length() > 0) {
							strCurDir = strCurDir + "/" + strDirs[i];
						} else {
							strCurDir = strDirs[i];
						}
						try {
							ftp.mkdir(strDirs[i]);
							log.info("Create Dir : " + strCurDir
									+ " OK!");
						} catch (FTPException ex1) {
						}
						ftp.chdir(strDirs[i]);
					}
					log.info("Change Dir : " + strCurDir + " OK!");
					
				}
			}

			ftp.setConnectMode(FTPConnectMode.PASV);

			for (int i = 0; i < _strSrcFiles.length; i++) {
				if (_strSrcFiles[i].length() <= 0) {
					continue;
				} else {
					if (!dirIsExist(_strSrcFiles[i])) {
						iRtn = FTP_LOCAL_FILE_ERROR;
						throw new IOException(_strSrcFiles[i]
								+ " : not such file!");
					}
				}

				int index = _strSrcFiles[i].lastIndexOf(File.separator);
				strfilename = _strSrcFiles[i].substring(index + 1);
				iRtn = FTP_TRANSFER_ERROR;
				ftp.put(_strSrcFiles[i], strfilename);
				log.info("Put file " + _strSrcFiles[i] + " OK!");
			}
			iRtn = FTP_LOGOUT_ERROR;
			ftp.quit();
			log.info("Logout!" + "\n");
			iRtn = FTP_OK;
		} 
		catch (FTPException ex) {
			log.error("ftpPutFile : " + ex.getMessage());
		} 
		catch (IOException ex1) {
			log.error("ftpPutFile : " + ex1.getMessage());
		} 
		catch (NumberFormatException ex2) {
			log.error("ftpPutFile : " + ex2.getMessage());
		}

		log.info("ftpFile end. iRtn = " + iRtn);
		return iRtn;
	}
	
	   /**
     * 
     * dirIsExist:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param _strDir
     * @return boolean
     * @since 1.0
     */
    public static boolean dirIsExist(String _strDir) {
        File dir = new File(_strDir);

        if (dir.exists())
            return true;

        return false;
    }

	public static List ftpGetFileNameList(String _strHost, String _strPort,
			String _strFtpUser, String _strFtpPwd, 
			String _strEntryDesDir, String _strFileName) {
		
		List<String> fileNameList = new ArrayList<String>();
		
		log.info("ip=" + _strHost + ", port=" + _strPort + ", user="
				+ _strFtpUser + ", passwd=" + _strFtpPwd + ", entryDir=" 
				+ _strEntryDesDir + ", file=" + _strFileName);

		if (_strFileName == null) {
			return null;
		}

		FTPClient ftp = null;

		try {
			ftp = new FTPClient();
			ftp.setRemoteHost(_strHost);
			ftp.setRemotePort(Integer.parseInt(_strPort));
			ftp.setTimeout(FTP_TIMEOUT);
			ftp.connect();
			ftp.login(_strFtpUser, _strFtpPwd);
			log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
			ftp.setType(FTPTransferType.BINARY);
			if (_strEntryDesDir.trim().length() > 0 && !_strEntryDesDir.trim().equals(".")) {
				if(_strEntryDesDir.substring(0, 1).equals("/")){	//绝对路径
					ftp.chdir(_strEntryDesDir.trim());
					log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
				}
				else{				//相对路径
					String[] strDirs = _strEntryDesDir.split("/", -1);
					if (strDirs != null) {
						String strCurDir = "";
						for (int i = 0; i < strDirs.length; i++) {
							if (strCurDir.length() > 0) {
								strCurDir = strCurDir + "/" + strDirs[i];
							} else {
								strCurDir = strDirs[i];
							}
							try {
								ftp.mkdir(strDirs[i]);
								log.info("Create Dir : " + strCurDir + " OK!");
							} catch (FTPException ex1) {
							}
							ftp.chdir(strDirs[i]);
						}
						log.info("Change Dir : " + strCurDir + " OK!");
					}
				}
			}

			ftp.setConnectMode(FTPConnectMode.PASV);
//			ftp.setConnectMode(FTPConnectMode.ACTIVE);
			
			String[] remortFileNames = ftp.dir(_strFileName + "*");
			for (int i = 0; i < remortFileNames.length; i++) {
				String fileName = remortFileNames[i];
				fileNameList.add(fileName);
			} 
			
			ftp.quit();
			log.info("Logout!" + "\n");
		} 
		catch (FTPException ex) {
			if(ex.getMessage().indexOf("No such file") >= 0){
				return fileNameList;
			}
			else if(ex.getMessage().indexOf("Bad directory") >= 0){
				return fileNameList;
			}
			else if(ex.getMessage().indexOf("Unexpected null reply received") >= 0){
				return fileNameList;
			}
			else{
				log.info("ftpGetFileNameList :" + ex.getMessage());
				return null;
			}
		} 
		catch (IOException ex1) {
			log.info("ftpGetFileNameList :" + ex1.getMessage());
			return null;
		} 
		catch (NumberFormatException ex2) {
			log.info("ftpGetFileNameList :" + ex2.getMessage());
			return null;
		}

		log.info("ftpGetFileNameList end. get filenames num=" + fileNameList.size());
		return fileNameList;
	}

	// dir list
	public static List ftpGetDirList(String _strHost, String _strPort,
			String _strFtpUser, String _strFtpPwd, 
			String _strEntryDesDir) {
		
		List<String> fileNameList = new ArrayList<String>();
		
		log.info("ip=" + _strHost + ", port=" + _strPort + ", user="
				+ _strFtpUser + ", passwd=" + _strFtpPwd + ", entryDir=" 
				+ _strEntryDesDir);

		FTPClient ftp = null;

		try {
			ftp = new FTPClient();
			ftp.setRemoteHost(_strHost);
			ftp.setRemotePort(Integer.parseInt(_strPort));
			ftp.setTimeout(FTP_TIMEOUT);
			ftp.connect();
			ftp.login(_strFtpUser, _strFtpPwd);
			log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
			ftp.setType(FTPTransferType.BINARY);
			if (_strEntryDesDir.trim().length() > 0 && !_strEntryDesDir.trim().equals(".")) {
				if(_strEntryDesDir.substring(0, 1).equals("/")){	//绝对路径
					ftp.chdir(_strEntryDesDir.trim());
					log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
				}
				else{				//相对路径
					String[] strDirs = _strEntryDesDir.split("/", -1);
					if (strDirs != null) {
						String strCurDir = "";
						for (int i = 0; i < strDirs.length; i++) {
							if (strCurDir.length() > 0) {
								strCurDir = strCurDir + "/" + strDirs[i];
							} else {
								strCurDir = strDirs[i];
							}
							try {
								ftp.mkdir(strDirs[i]);
								log.info("Create Dir : " + strCurDir + " OK!");
							} catch (FTPException ex1) {
							}
							ftp.chdir(strDirs[i]);
						}
						log.info("Change Dir : " + strCurDir + " OK!");
					}
				}
			}

			ftp.setConnectMode(FTPConnectMode.PASV);
//			ftp.setConnectMode(FTPConnectMode.ACTIVE);
			
			String[] remortFileNames = ftp.dir(".", true);
			String[] remortFileNameList = ftp.dir();
			for (int i = 0; i < remortFileNames.length; i++) {
				String fileName = remortFileNames[i];
				if(isDir(fileName)){
					fileNameList.add(remortFileNameList[i]);
				}
			}
			ftp.quit();
			log.info("Logout!" + "\n");
		} 
		catch (FTPException ex) {
			if(ex.getMessage().indexOf("No such file") >= 0){
				return fileNameList;
			}
			else if(ex.getMessage().indexOf("Bad directory") >= 0){
				return fileNameList;
			}
			else if(ex.getMessage().indexOf("Unexpected null reply received") >= 0){
				return fileNameList;
			}
			else{
				log.info("ftpGetDirList :" + ex.getMessage());
				return null;
			}
		} 
		catch (IOException ex1) {
			log.info("ftpGetDirList :" + ex1.getMessage());
			return null;
		} 
		catch (NumberFormatException ex2) {
			log.info("ftpGetDirList :" + ex2.getMessage());
			return null;
		}

		log.info("ftpGetDirList end. get dirnames num=" + fileNameList.size());
		return fileNameList;
	}
	
	private static boolean isDir(String remortFileName){
		boolean flag = false;
		if("d".equals(remortFileName.substring(0, 1))){
			flag = true;
		}
		return flag;
	}
	
//	public static List ftpGetFile(String _strHost, String _strPort,
//			String _strFtpUser, String _strFtpPwd, 
//			String _strEntryDesDir, String _strFileName, int _iFileNum, String _strLocalFileDir) {
//		return ftpGetFile(_strHost, _strPort,
//				_strFtpUser, _strFtpPwd, 
//				_strEntryDesDir, _strFileName, _iFileNum, _strLocalFileDir , "");
//	}
	
//	public static List ftpGetFile(String _strHost, String _strPort,
//			String _strFtpUser, String _strFtpPwd, 
//			String _strEntryDesDir, String _strFileName, int _iFileNum, String _strLocalFileDir, String _strIgnoreFileName) {
//		
//		int iRtn = FTP_NO_FILE_TRANSFER;
//		List<String> fileList = new ArrayList<String>();
//		
//		log.info("ip=" + _strHost + ", port=" + _strPort + ", user="
//				+ _strFtpUser + ", passwd=" + _strFtpPwd + ", entryDir=" 
//				+ _strEntryDesDir + ", file=" + _strFileName + ", num=" + _iFileNum );
//
//		if (_strFileName == null || _iFileNum == 0 || _strLocalFileDir == null) {
//			return null;
//		}
//
//		FTPClient ftp = null;
//
//		try {
//			iRtn = FTP_CONNECT_ERROR;
//			ftp = new FTPClient();
//			ftp.setRemoteHost(_strHost);
//			ftp.setRemotePort(Integer.parseInt(_strPort));
//			ftp.setTimeout(FTP_TIMEOUT);
//			ftp.connect();
//			iRtn = FTP_LOGIN_ERROR;
//			ftp.login(_strFtpUser, _strFtpPwd);
//			log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
//			ftp.setType(FTPTransferType.BINARY);
//			if (_strEntryDesDir.trim().length() > 0 && !_strEntryDesDir.trim().equals(".")) {
//				if(_strEntryDesDir.substring(0, 1).equals("/")){	//绝对路径
//					ftp.chdir(_strEntryDesDir.trim());
//					log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
//				}
//				else{				//相对路径
//					String[] strDirs = _strEntryDesDir.split("/", -1);
//					if (strDirs != null) {
//						String strCurDir = "";
//						for (int i = 0; i < strDirs.length; i++) {
//							if (strCurDir.length() > 0) {
//								strCurDir = strCurDir + "/" + strDirs[i];
//							} else {
//								strCurDir = strDirs[i];
//							}
//							try {
//								ftp.mkdir(strDirs[i]);
//								log.info("Create Dir : " + strCurDir + " OK!");
//							} catch (FTPException ex1) {
//							}
//							ftp.chdir(strDirs[i]);
//						}
//						log.info("Change Dir : " + strCurDir + " OK!");
//					}
//				}
//			}
//
//			if(!dirIsExist(_strLocalFileDir)){
//				SystemUtil.createDir(_strLocalFileDir);
//			}
//
//			ftp.setConnectMode(FTPConnectMode.PASV);
//			
//			String[] remortFileNames = ftp.dir(_strFileName + "*");
//			for (int i = 0; i < remortFileNames.length; i++) {
//				if(!ConvertUtil.nvl(_strIgnoreFileName).equals("")){
//					if(remortFileNames[i].indexOf(_strIgnoreFileName) >= 0){
//						continue;
//					}
//				}
//				String localFile = _strLocalFileDir + File.separator + remortFileNames[i];
//				iRtn = FTP_TRANSFER_ERROR;
//				ftp.get(localFile, remortFileNames[i]);
//				log.info("Get file " + remortFileNames[i]);
//				fileList.add(localFile);
//				
//				if(i + 1 == _iFileNum){
//					break;
//				}
//			} 
//			iRtn = FTP_LOGOUT_ERROR;
//			ftp.quit();
//			log.info("Logout!" + "\n");
//		} 
//		catch (FTPException ex) {
//			if(iRtn == FTP_LOGOUT_ERROR){
//				return fileList;
//			}else{
//				if(ex.getMessage().indexOf("No such file") >= 0){
//					return fileList;
//				}
//				else if(ex.getMessage().indexOf("Bad directory") >= 0){
//					return fileList;
//				}
//				else{
//					log.error("ftpGetFile :" + ex.getMessage());
//					return null;
//				}
//			}
//		} 
//		catch (IOException ex1) {
//			if(iRtn == FTP_LOGOUT_ERROR){
//				return fileList;
//			}else{
//				log.info("ftpGetFile :" + ex1.getMessage());
//				return null;
//			}
//		} 
//		catch (NumberFormatException ex2) {
//			if(iRtn == FTP_LOGOUT_ERROR){
//				return fileList;
//			}else{
//				log.info("ftpGetFile :" + ex2.getMessage());
//				return null;
//			}
//		}
//
//		log.info("ftpGetFile end. get files num=" + fileList.size());
//		return fileList;
//	}

	public static int ftpDeleteFile(String _strHost, String _strPort,
			String _strFtpUser, String _strFtpPwd, String _strEntryDesDir,
			String[] _strFileNames) {
		int iRtn = FTP_NO_FILE_TRANSFER;
		if (_strFileNames.length <= 0) {
			return 0;
		}
		
		FTPClient ftp = null;

		try {
			ftp = new FTPClient();
			ftp.setRemoteHost(_strHost);
			ftp.setRemotePort(Integer.parseInt(_strPort));
			ftp.setTimeout(FTP_TIMEOUT);
			ftp.connect();
			ftp.login(_strFtpUser, _strFtpPwd);
			log.info("Login OK![" + _strHost + ":" + _strPort + ":" + _strFtpUser + "]");
			ftp.setType(FTPTransferType.BINARY);
			ftp.setConnectMode(FTPConnectMode.PASV);
			if (_strEntryDesDir.trim().length() > 0) {
				if(_strEntryDesDir.substring(0, 1).equals("/")){	//绝对路径
					ftp.chdir(_strEntryDesDir.trim());
					log.info("Change Dir : " + _strEntryDesDir.trim() + " OK!");
				}
				else{				//相对路径
					String[] strDirs = _strEntryDesDir.split("/", -1);
					if (strDirs != null) {
						String strCurDir = "";
						for (int i = 0; i < strDirs.length; i++) {
							if (strCurDir.length() > 0) {
								strCurDir = strCurDir + "/" + strDirs[i];
							} else {
								strCurDir = strDirs[i];
							}
							ftp.chdir(strDirs[i]);
						}
						log.info("Change Dir : " + strCurDir + " OK!");
					}
				}
			}

			for (int i = 0; i < _strFileNames.length; i++) {
				if (_strFileNames[i].length() <= 0)
					continue;

				try {
					ftp.delete(_strFileNames[i]);
					log.info("Delete file " + _strFileNames[i]
							+ " OK!");
				} catch (FTPException ex1) {
					log.info("Delete file " + _strFileNames[i]
							+ " FAIL!" + ex1.getMessage());
				} catch (IOException ex1) {
					log.info("Delete file " + _strFileNames[i]
							+ " FAIL!" + ex1.getMessage());
				}
			}
			iRtn = FTP_LOGOUT_ERROR;
			ftp.quit();
			log.info("Logout!" + "\n");
		} 
		catch (FTPException ex) {
			log.info("ftpDeleteFile : " + ex.getMessage());
			return -1;
		} 
		catch (IOException ex1) {
			log.info("ftpDeleteFile : " + ex1.getMessage());
			return -2;
		} 
		catch (NumberFormatException ex2) {
			log.info("ftpDeleteFile : " + ex2.getMessage());
			return -3;
		}

		return 0;
	}

	public static int ftpRenameFile(String _strHost, String _strPort,
			String _strFtpUser, String _strFtpPwd, String _strEntryDir,
			String[] _strEntrySrcFilePaths, String[] _strEntryDesFilePaths) {
		int iRtn = FTP_NO_FILE_TRANSFER;
		if (_strEntrySrcFilePaths.length <= 0) {
			return 0;
		}

		if (_strEntryDesFilePaths.length <= 0) {
			return 0;
		}

		FTPClient ftp = null;

		try {
			iRtn = FTP_CONNECT_ERROR;
			ftp = new FTPClient();
			ftp.setRemoteHost(_strHost);
			ftp.setRemotePort(Integer.parseInt(_strPort));
			ftp.setTimeout(FTP_TIMEOUT);
			ftp.connect();
			iRtn = FTP_LOGIN_ERROR;
			ftp.login(_strFtpUser, _strFtpPwd);
			log.info("Login OK![" + _strHost + ":" + _strPort + ":"
					+ _strFtpUser + "]");
			ftp.setType(FTPTransferType.BINARY);
			ftp.setConnectMode(FTPConnectMode.PASV);
			if (_strEntryDir.trim().length() > 0) {
				String[] strDirs = _strEntryDir.split("/", -1);
				if (strDirs != null) {
					String strCurDir = "";
					for (int i = 0; i < strDirs.length; i++) {
						if (strCurDir.length() > 0) {
							strCurDir = strCurDir + "/" + strDirs[i];
						} else {
							strCurDir = strDirs[i];
						}
						ftp.chdir(strDirs[i]);
					}
					log.info("Change Dir : " + strCurDir + " OK!");
				}
			}

			for (int i = 0; i < _strEntrySrcFilePaths.length; i++) {
				if (_strEntrySrcFilePaths[i].length() <= 0)
					continue;
				if (_strEntryDesFilePaths[i].length() <= 0)
					continue;

				String[] strDirs = _strEntryDesFilePaths[i].split("/", -1);
				if (strDirs != null) {
					String strDesDir = "";
					for (int j = 0; j < strDirs.length - 1; j++) {
						if (j == 0) {
							strDesDir += strDirs[j];
						} else {
							strDesDir += "/" + strDirs[j];
						}

						try {
							ftp.mkdir(strDesDir);
							log.info("Create Dir : " + strDesDir
									+ " OK!");
						} catch (FTPException ex1) {
						}
					}
				}

				try {
					iRtn = FTP_TRANSFER_ERROR;
					ftp.rename(_strEntrySrcFilePaths[i],
							_strEntryDesFilePaths[i]);
					log.info("Rename file "
							+ _strEntrySrcFilePaths[i] + " to "
							+ _strEntryDesFilePaths[i] + " OK!");
				} catch (FTPException ex1) {
					log.error("Rename file "
							+ _strEntrySrcFilePaths[i] + " to "
							+ _strEntryDesFilePaths[i] + " FAIL! "
							+ ex1.getMessage());
				} catch (IOException ex1) {
					log.error("Rename file "
							+ _strEntrySrcFilePaths[i] + " to "
							+ _strEntryDesFilePaths[i] + " FAIL! b"
							+ ex1.getMessage());
				}
			}
			iRtn = FTP_LOGOUT_ERROR;
			ftp.quit();
			iRtn = FTP_OK;
			log.info("Logout!" + "\n");
		} catch (FTPException ex) {
			log.error(ex.getMessage(), ex);
			ex.printStackTrace();
//			return -1;
		} catch (IOException ex) {
			log.error(ex.getMessage(), ex);
			ex.printStackTrace();
//			return -2;
		} catch (NumberFormatException ex2) {
			log.error(ex2.getMessage(),ex2);
			ex2.printStackTrace();
//			return -3;
		}

		return iRtn;
	}

}
