package cn.spatiotemporal.commons.file.service;

import org.springframework.web.multipart.MultipartFile;

import cn.spatiotemporal.commons.file.vo.FileInfo;

/**
 * 
 * @ClassName: FileService
 * @Description: 文件接口（计划实现minio/ftp）
 * @date 2023年9月13日 上午10:07:40
 * 
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
public interface FileService {

	/**
	 * 上传文件
	 * 
	 * @param file 表单文件对象
	 * @return
	 */
	FileInfo uploadFile(MultipartFile file);

	/**
	 * 删除文件
	 *
	 * @param filePath 文件路径
	 * @return
	 */
	boolean deleteFile(String filePath);
}
