package cn.spatiotemporal.commons.file.controller;

import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import cn.spatiotemporal.commons.enums.ReturnEnum;
import cn.spatiotemporal.commons.file.service.FileService;
import cn.spatiotemporal.commons.file.vo.FileInfo;
import cn.spatiotemporal.commons.result.ReturnVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;

/**
 * 
 * @ClassName: FileController    
 * @Description: 文件服务控制器
 * @date 2023年9月13日 上午11:08:30    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
 */

@Api(tags = "文件接口")
@RestController
@RequestMapping("/api/v1/files")
@RequiredArgsConstructor
public class FileController {
    private final FileService fileService;

    @PostMapping("/upload")
    @ApiOperation(value = "文件上传")
    public ReturnVO<FileInfo> uploadFile(@ApiParam("表单文件对象") @RequestParam(value = "file") MultipartFile file) {      
        return new ReturnVO<FileInfo>(ReturnEnum.SUCCESS, fileService.uploadFile(file));
    }

    @DeleteMapping("/delete")
    @ApiOperation(value = "文件删除")
    @SneakyThrows
    public ReturnVO<Boolean> deleteFile(@ApiParam("文件路径") @RequestParam String filePath) {
        return new ReturnVO<Boolean>(ReturnEnum.SUCCESS, fileService.deleteFile(filePath));
    }    
}
