/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.mybatis.transaction;

import cn.pomit.mybatis.annotation.Transactional;
import cn.pomit.mybatis.exception.ProxyErrorException;
import cn.pomit.mybatis.sqlsession.SqlSessionTemplate;
import cn.pomit.mybatis.sqlsession.SqlSessionUtils;
import cn.pomit.mybatis.transaction.AbstractTransactionHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.ExceptionUtil;

public class TransactionProxy
implements InvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(TransactionProxy.class);
    private Object targert = null;
    private boolean hasTransaction = false;
    private SqlSessionTemplate sqlSessionTemplate;
    private Class<? extends Throwable>[] exceptions;

    public TransactionProxy(Class<?> cls, SqlSessionTemplate sqlSessionTemplate) throws ProxyErrorException {
        try {
            this.targert = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sqlSessionTemplate = sqlSessionTemplate;
            Transactional transactional = cls.getAnnotation(Transactional.class);
            if (transactional != null) {
                this.hasTransaction = true;
                this.exceptions = transactional.rollbackFor();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4ee3\u7406\u5bf9\u8c61\u751f\u6210\u5931\u8d25\uff0c\u65e0\u6784\u9020\u51fd\u6570\uff1f", (Throwable)e);
            throw new ProxyErrorException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.hasTransaction) {
            LOGGER.debug("no \u4e8b\u52a1");
            return method.invoke(this.targert, args);
        }
        AbstractTransactionHolder transactionHolder = SqlSessionUtils.registerTransaction(this.sqlSessionTemplate.getSqlSessionFactory(), this.sqlSessionTemplate.getExecutorType());
        LOGGER.debug("\u4e8b\u52a1\u6ce8\u518c\u6210\u529f");
        try {
            Object result = method.invoke(this.targert, args);
            transactionHolder.commitTransaction();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            Throwable unwrap = ExceptionUtil.unwrapThrowable((Throwable)e);
            boolean isCommit = true;
            if (this.exceptions == null || this.exceptions.length < 1) {
                if (unwrap instanceof RuntimeException) {
                    transactionHolder.rollbackTransaction();
                    isCommit = false;
                }
            } else {
                boolean catchExcep = false;
                for (Class<? extends Throwable> exp : this.exceptions) {
                    if (!exp.isAssignableFrom(unwrap.getClass())) continue;
                    catchExcep = true;
                    break;
                }
                if (catchExcep) {
                    isCommit = false;
                    transactionHolder.rollbackTransaction();
                }
            }
            if (isCommit) {
                transactionHolder.commitTransaction();
            }
            throw unwrap;
        }
        finally {
            SqlSessionUtils.deRegisterTransaction(transactionHolder, this.sqlSessionTemplate.getSqlSessionFactory());
        }
    }
}

