/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.mybatis.sqlsession;

import cn.pomit.mybatis.transaction.AbstractTransactionHolder;
import cn.pomit.mybatis.transaction.NoneTransactionHolder;
import cn.pomit.mybatis.transaction.TransactionHolder;
import cn.pomit.mybatis.transaction.TransactionManager;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlSessionUtils {
    private static final Log LOGGER = LogFactory.getLog(SqlSessionUtils.class);

    public static AbstractTransactionHolder getTransactionHolder(SqlSessionFactory sessionFactory) {
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getTransactionHolder(sessionFactory, executorType);
    }

    public static AbstractTransactionHolder getTransactionHolder(SqlSessionFactory sessionFactory, ExecutorType executorType) {
        LOGGER.debug("\u5f00\u542f SqlSession\u3002");
        AbstractTransactionHolder transactionHolder = (AbstractTransactionHolder)TransactionManager.getResource(sessionFactory);
        if (transactionHolder == null) {
            transactionHolder = new NoneTransactionHolder(sessionFactory.openSession(executorType));
            return transactionHolder;
        }
        return transactionHolder;
    }

    public static AbstractTransactionHolder registerTransaction(SqlSessionFactory sessionFactory, ExecutorType executorType) {
        LOGGER.debug("\u5f00\u542f\u4e8b\u52a1\u7ed1\u5b9a\u3002");
        TransactionHolder transactionHolder = new TransactionHolder(sessionFactory.openSession(executorType));
        TransactionManager.bindResource(sessionFactory, transactionHolder);
        return transactionHolder;
    }

    public static void deRegisterTransaction(AbstractTransactionHolder transactionHolder, SqlSessionFactory sessionFactory) {
        SqlSession session = transactionHolder.getSqlSession();
        if (session != null) {
            session.close();
            session = null;
        }
        LOGGER.debug("\u4e8b\u52a1\u89e3\u7ed1\u5173\u95ed\u3002");
        TransactionManager.unbindResource(sessionFactory);
    }
}

