/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.mybatis.configuration;

import cn.pomit.mybatis.exception.ParamsNeedException;
import cn.pomit.mybatis.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.DataSourceFactory;
import org.apache.ibatis.datasource.jndi.JndiDataSourceFactory;
import org.apache.ibatis.datasource.pooled.PooledDataSourceFactory;
import org.apache.ibatis.datasource.unpooled.UnpooledDataSourceFactory;

public class MybatisProperties {
    public static final String PACKAGE_NAME_KEY = "mybatis.mapper.scan";
    public static final String DATASOURCE_PREFIX = "mybatis.datasource.";
    private final Map<String, Class<?>> TYPE_ALIASES = new HashMap();
    private DataSource dataSource = null;
    private String packageName = null;
    private Properties properties = null;

    public MybatisProperties(String packageName, Properties properties) {
        this(packageName, null, properties);
    }

    public MybatisProperties(Properties properties) {
        this(null, null, properties);
    }

    public MybatisProperties(String packageName, DataSource dataSource) {
        this(packageName, dataSource, null);
    }

    public MybatisProperties(String packageName, DataSource dataSource, Properties properties) {
        this.TYPE_ALIASES.put("UNPOOLED", UnpooledDataSourceFactory.class);
        this.TYPE_ALIASES.put("POOLED", PooledDataSourceFactory.class);
        this.TYPE_ALIASES.put("JNDI", JndiDataSourceFactory.class);
        this.dataSource = dataSource;
        this.packageName = packageName;
        this.properties = properties;
        if (packageName == null && properties == null) {
            throw new ParamsNeedException("\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a\uff0cpackageName\u65e0\u6cd5\u83b7\u53d6\uff01");
        }
        if (dataSource == null && properties == null) {
            throw new ParamsNeedException("\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a\uff0cdataSource\u65e0\u6cd5\u83b7\u53d6\uff01");
        }
        if (packageName == null) {
            String name = properties.getProperty(PACKAGE_NAME_KEY);
            if (StringUtil.isEmpty(name)) {
                throw new ParamsNeedException("\u914d\u7f6e\u6587\u4ef6\u672a\u83b7\u53d6\u5230mybatis.mapper.scan\u53c2\u6570\uff01");
            }
            this.packageName = name;
        }
        if (dataSource == null) {
            String datasourceType = "mybatis.datasource.type";
            String type = properties.getProperty(datasourceType);
            if (StringUtil.isEmpty(type)) {
                throw new ParamsNeedException("\u914d\u7f6e\u6587\u4ef6\u672a\u83b7\u53d6\u5230mybatis.datasource.type\u53c2\u6570\uff01");
            }
            Properties props = new Properties();
            for (Object key : properties.keySet()) {
                String tmpKey = key.toString();
                if (!tmpKey.startsWith(DATASOURCE_PREFIX) || datasourceType.equals(tmpKey)) continue;
                String datasourceKey = tmpKey.replace(DATASOURCE_PREFIX, "");
                props.put(datasourceKey, properties.get(key));
            }
            try {
                DataSourceFactory factory = (DataSourceFactory)this.TYPE_ALIASES.get(type.toUpperCase()).newInstance();
                factory.setProperties(props);
                this.dataSource = factory.getDataSource();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ParamsNeedException("datasource\u751f\u6210\u5931\u8d25\uff01", e);
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

