/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.read.metadata.holder;

import cn.idev.excel.converters.Converter;
import cn.idev.excel.converters.ConverterKeyBuild;
import cn.idev.excel.converters.DefaultConverterLoader;
import cn.idev.excel.enums.HolderEnum;
import cn.idev.excel.metadata.AbstractHolder;
import cn.idev.excel.metadata.ConfigurationHolder;
import cn.idev.excel.read.listener.ModelBuildEventListener;
import cn.idev.excel.read.listener.ReadListener;
import cn.idev.excel.read.metadata.ReadBasicParameter;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.read.metadata.holder.ReadHolder;
import cn.idev.excel.read.metadata.property.ExcelReadHeadProperty;
import cn.idev.excel.util.ListUtils;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractReadHolder
extends AbstractHolder
implements ReadHolder {
    private Integer headRowNumber;
    private ExcelReadHeadProperty excelReadHeadProperty;
    private List<ReadListener<?>> readListenerList;

    public AbstractReadHolder(ReadBasicParameter readBasicParameter, AbstractReadHolder parentAbstractReadHolder) {
        super(readBasicParameter, parentAbstractReadHolder);
        Boolean useDefaultListener;
        if (readBasicParameter.getUseScientificFormat() == null) {
            if (parentAbstractReadHolder != null) {
                this.getGlobalConfiguration().setUseScientificFormat(parentAbstractReadHolder.getGlobalConfiguration().getUseScientificFormat());
            }
        } else {
            this.getGlobalConfiguration().setUseScientificFormat(readBasicParameter.getUseScientificFormat());
        }
        this.excelReadHeadProperty = new ExcelReadHeadProperty((ConfigurationHolder)this, (Class)this.getClazz(), this.getHead());
        this.headRowNumber = readBasicParameter.getHeadRowNumber() == null ? (parentAbstractReadHolder == null ? (this.excelReadHeadProperty.hasHead() ? Integer.valueOf(this.excelReadHeadProperty.getHeadRowNumber()) : Integer.valueOf(1)) : parentAbstractReadHolder.getHeadRowNumber()) : readBasicParameter.getHeadRowNumber();
        this.readListenerList = parentAbstractReadHolder == null ? ListUtils.newArrayList() : ListUtils.newArrayList(parentAbstractReadHolder.getReadListenerList());
        if (HolderEnum.WORKBOOK.equals((Object)this.holderType()) && ((useDefaultListener = ((ReadWorkbook)readBasicParameter).getUseDefaultListener()) == null || useDefaultListener.booleanValue())) {
            this.readListenerList.add(new ModelBuildEventListener());
        }
        if (readBasicParameter.getCustomReadListenerList() != null && !readBasicParameter.getCustomReadListenerList().isEmpty()) {
            this.readListenerList.addAll(readBasicParameter.getCustomReadListenerList());
        }
        if (parentAbstractReadHolder == null) {
            this.setConverterMap(DefaultConverterLoader.loadDefaultReadConverter());
        } else {
            this.setConverterMap(new HashMap(parentAbstractReadHolder.getConverterMap()));
        }
        if (readBasicParameter.getCustomConverterList() != null && !readBasicParameter.getCustomConverterList().isEmpty()) {
            for (Converter<?> converter : readBasicParameter.getCustomConverterList()) {
                this.getConverterMap().put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
            }
        }
    }

    @Override
    public List<ReadListener<?>> readListenerList() {
        return this.getReadListenerList();
    }

    @Override
    public ExcelReadHeadProperty excelReadHeadProperty() {
        return this.getExcelReadHeadProperty();
    }

    public Integer getHeadRowNumber() {
        return this.headRowNumber;
    }

    public ExcelReadHeadProperty getExcelReadHeadProperty() {
        return this.excelReadHeadProperty;
    }

    public List<ReadListener<?>> getReadListenerList() {
        return this.readListenerList;
    }

    public void setHeadRowNumber(Integer headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public void setExcelReadHeadProperty(ExcelReadHeadProperty excelReadHeadProperty) {
        this.excelReadHeadProperty = excelReadHeadProperty;
    }

    public void setReadListenerList(List<ReadListener<?>> readListenerList) {
        this.readListenerList = readListenerList;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractReadHolder)) {
            return false;
        }
        AbstractReadHolder other = (AbstractReadHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$headRowNumber = this.getHeadRowNumber();
        Integer other$headRowNumber = other.getHeadRowNumber();
        if (this$headRowNumber == null ? other$headRowNumber != null : !((Object)this$headRowNumber).equals(other$headRowNumber)) {
            return false;
        }
        ExcelReadHeadProperty this$excelReadHeadProperty = this.getExcelReadHeadProperty();
        ExcelReadHeadProperty other$excelReadHeadProperty = other.getExcelReadHeadProperty();
        if (this$excelReadHeadProperty == null ? other$excelReadHeadProperty != null : !((Object)this$excelReadHeadProperty).equals(other$excelReadHeadProperty)) {
            return false;
        }
        List<ReadListener<?>> this$readListenerList = this.getReadListenerList();
        List<ReadListener<?>> other$readListenerList = other.getReadListenerList();
        return !(this$readListenerList == null ? other$readListenerList != null : !((Object)this$readListenerList).equals(other$readListenerList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractReadHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $headRowNumber = this.getHeadRowNumber();
        result = result * 59 + ($headRowNumber == null ? 43 : ((Object)$headRowNumber).hashCode());
        ExcelReadHeadProperty $excelReadHeadProperty = this.getExcelReadHeadProperty();
        result = result * 59 + ($excelReadHeadProperty == null ? 43 : ((Object)$excelReadHeadProperty).hashCode());
        List<ReadListener<?>> $readListenerList = this.getReadListenerList();
        result = result * 59 + ($readListenerList == null ? 43 : ((Object)$readListenerList).hashCode());
        return result;
    }

    public AbstractReadHolder() {
    }
}

