/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.spring.context.path;

import cn.dev33.satoken.application.ApplicationInfo;
import cn.dev33.satoken.util.SaFoxUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class ApplicationContextPathLoading
implements ApplicationRunner {
    @Value(value="${server.servlet.context-path:}")
    String contextPath;
    @Value(value="${spring.mvc.servlet.path:}")
    String servletPath;

    public void run(ApplicationArguments args) throws Exception {
        String routePrefix = "";
        if (SaFoxUtil.isNotEmpty((Object)this.contextPath)) {
            if (!this.contextPath.startsWith("/")) {
                this.contextPath = "/" + this.contextPath;
            }
            if (this.contextPath.endsWith("/")) {
                this.contextPath = this.contextPath.substring(0, this.contextPath.length() - 1);
            }
            routePrefix = routePrefix + this.contextPath;
        }
        if (SaFoxUtil.isNotEmpty((Object)this.servletPath)) {
            if (!this.servletPath.startsWith("/")) {
                this.servletPath = "/" + this.servletPath;
            }
            if (this.servletPath.endsWith("/")) {
                this.servletPath = this.servletPath.substring(0, this.servletPath.length() - 1);
            }
            routePrefix = routePrefix + this.servletPath;
        }
        if (SaFoxUtil.isNotEmpty((Object)routePrefix) && !routePrefix.equals("/")) {
            ApplicationInfo.routePrefix = routePrefix;
        }
    }
}

