/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.engine;

import ai.djl.ndarray.types.DataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PpDataType {
    private static Map<DataType, Integer> toPaddlePaddleMap = PpDataType.createMapToPaddlePaddle();
    private static Map<Integer, DataType> fromPaddlePaddleMap = PpDataType.createMapFromPaddlePaddle();

    private PpDataType() {
    }

    private static Map<DataType, Integer> createMapToPaddlePaddle() {
        ConcurrentHashMap<DataType, Integer> map = new ConcurrentHashMap<DataType, Integer>();
        map.put(DataType.FLOAT32, 0);
        map.put(DataType.INT64, 1);
        map.put(DataType.INT32, 2);
        map.put(DataType.UINT8, 3);
        map.put(DataType.INT8, 4);
        map.put(DataType.FLOAT16, 5);
        return map;
    }

    private static Map<Integer, DataType> createMapFromPaddlePaddle() {
        ConcurrentHashMap<Integer, DataType> map = new ConcurrentHashMap<Integer, DataType>();
        map.put(0, DataType.FLOAT32);
        map.put(1, DataType.INT64);
        map.put(2, DataType.INT32);
        map.put(3, DataType.UINT8);
        map.put(4, DataType.INT8);
        map.put(5, DataType.FLOAT16);
        return map;
    }

    public static DataType fromPaddlePaddle(int ppType) {
        return fromPaddlePaddleMap.get(ppType);
    }

    public static int toPaddlePaddle(DataType jType) {
        Integer ppType = toPaddlePaddleMap.get(jType);
        if (ppType == null) {
            throw new UnsupportedOperationException("PaddlePaddle doesn't support dataType: " + jType);
        }
        return ppType;
    }
}

