package com.inzy.wsmock


import org.springframework.messaging.simp.SimpMessagingTemplate
import org.springframework.scheduling.annotation.Scheduled
import org.springframework.stereotype.Component
import java.text.SimpleDateFormat
import java.util.*

/**
 * 定时推送消息到 /topic/greetings 主题
 */
@Component
class ScheduledMessageSender(
    private val messagingTemplate: SimpMessagingTemplate, // 注入STOMP消息模板
    private val messageController: GreetingController // 注入控制层
) {
    // 定义定时规则：每5秒推送一次（可根据需求调整，比如 1000=1秒，60000=1分钟）
    // cron表达式参考：0/5 * * * * ? （每5秒执行）
    @Scheduled(fixedRate = 5000)
    fun sendPeriodicMessage() {
        if (messageController.pushEnabled) {
            // 1. 构造推送内容（可替换为业务数据）
            val time = SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Date())
            val greetingContent = "定时推送消息 - $time"


            // 2. 发送到 /topic/greetings 主题（前端已订阅该主题）
            messagingTemplate.convertAndSend("/topic/greetings", Greeting(greetingContent))
            println("已推送定时消息：$greetingContent")
        }
    }
}