package com.inzy.wsmock

import org.springframework.messaging.handler.annotation.MessageMapping
import org.springframework.messaging.handler.annotation.SendTo
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.util.HtmlUtils

@RestController
class GreetingController{
    @MessageMapping("/hello")
    @SendTo("/topic/greetings")
    @Throws(Exception::class)
    fun greeting(message: HelloMessage): Greeting {
        Thread.sleep(1000) // simulated delay
        return Greeting("Hello, " + HtmlUtils.htmlEscape(message.name) + "!")
    }

    // 新增开关变量
    var pushEnabled = false

    @GetMapping("/togglePush")
    fun togglePush(@RequestParam enable: Boolean): String {
        pushEnabled = enable
        return "服务器定时推送已${if (enable) "开启" else "关闭"}"
    }
}