package com.inzy.wsmock.push

import com.inzy.wsmock.RequestParamHandler
import io.netty.channel.Channel
import org.springframework.stereotype.Component

@Component
class PushFactory(
    private val adasPushTask: AdasPushTask
) {

    /**根据路径推送***/
    fun pushMsgFormPath(channel: Channel) {
        var path = ""
        if (channel.hasAttr(RequestParamHandler.REQUEST_PATH_KEY)) {
            path = channel.attr(RequestParamHandler.REQUEST_PATH_KEY).get()
        }
        val pushTask = createPushProduct(path)
        var type: String? = ""
        if (channel.hasAttr(RequestParamHandler.REQUEST_PARAMS_KEY)) {
            val params = channel.attr(RequestParamHandler.Companion.REQUEST_PARAMS_KEY).get()
            type = params.get(RequestParamHandler.PARAM_TYPE_KEY)
        }

        type?.let { pushTask.pushMsgFromType(it, channel) }

    }


    private fun createPushProduct(path: String): PushTask {
        when (path) {
            "/ws/adas" -> {
                return adasPushTask
            }

            else -> {
                throw IllegalArgumentException("Unknown product type")
            }
        }
    }


}