package com.inzy.wsmock

import jakarta.annotation.PreDestroy
import org.springframework.stereotype.Component
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicInteger

@Component
class PushConfig {
    // 定时推送开关（默认关闭）
    val pushStart = AtomicInteger(0)
    // 推送间隔（毫秒，默认5秒）
    var pushInterval: Long = 5000

    @PreDestroy
    fun destroy() {
        pushStart.set(0)
    }
}