package com.inzy.wsmock


import com.alibaba.fastjson2.JSONObject
import org.springframework.scheduling.annotation.Scheduled
import org.springframework.stereotype.Component
import java.time.LocalDateTime

@Component
class ScheduledPushTask(
    private val webSocketHandler: WebSocketHandler,
    private val pushConfig: PushConfig
) {
    /**
     * 定时推送任务（固定延迟，避免任务叠加）
     */
//    @Scheduled(fixedDelayString = "#{@pushConfig.pushInterval}")
    @Scheduled(fixedRate = 1000)
    fun pushMsgToClients() {
        // 开关关闭时跳过
//        if (!pushConfig.pushEnabled.get()) {
//            return
//        }
        // 构造推送消息（适配前端格式）
        val msgObj = JSONObject()
        msgObj["content"] = "定时推送消息 - ${LocalDateTime.now()}"
        println("--------msgObj = ${msgObj}")
        // 广播给所有客户端
        webSocketHandler.broadcastMsg(msgObj.toJSONString())
    }
}