package com.inzy.wsmock.push

import com.inzy.wsmock.RequestParamHandler
import io.netty.channel.Channel
import jakarta.annotation.PreDestroy
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.ApplicationContext
import org.springframework.stereotype.Component

@Component
class PushFactory(
    private val adasPushTask: AdasPushTask
) {

//    @Autowired
//    private lateinit var applicationContext: ApplicationContext

//    private var adasPushTask: AdasPushTask? = null


    /**根据路径推送***/
    fun pushMsgFormPath(channel: Channel) {
        var path = ""
        if (channel.hasAttr(RequestParamHandler.REQUEST_PATH_KEY)) {
            path = channel.attr(RequestParamHandler.REQUEST_PATH_KEY).get()
        }
        val pushTask = createPushProduct(path)
        var type: String? = ""
        if (channel.hasAttr(RequestParamHandler.REQUEST_PARAMS_KEY)) {
            val params = channel.attr(RequestParamHandler.Companion.REQUEST_PARAMS_KEY).get()
            type = params.get(RequestParamHandler.PARAM_TYPE_KEY)
        }

        type?.let { pushTask.pushMsgFromType(it, channel) }

    }


    private fun createPushProduct(path: String): PushTask {
        when (path) {
            "/ws/adas" -> {
                // 关键：每次调用 getBean 都会创建新的 AdasPushTask 实例
//                return applicationContext.getBean(AdasPushTask::class.java)
                return adasPushTask
            }

            else -> {
                throw IllegalArgumentException("Unknown product type")
            }
        }
    }

//    @PreDestroy
//    fun destroy() {
////        println("-=---PushFactory.destroy")
//        adasPushTask?.destroy()
//    }


}