package com.inzy.wsmock.utils

import java.io.InputStream

object FileIoUtil {

    fun getMockToList(inputStream: InputStream, dst: MutableList<String>) {
        // 方式1：手动逐行读取（推荐，Kotlin简洁写法）
        inputStream.use { inputStream -> // use 自动关闭流（AutoCloseable）
            inputStream.bufferedReader().forEachLine { line ->
                // 处理每行内容（示例：添加到列表 + 打印）
                dst.add(line)
//                println("读取到行 = ${line}")
            }
        }
    }


}