package com.inzy.wsmock


import com.alibaba.fastjson2.JSONObject
import lombok.extern.slf4j.Slf4j
import org.slf4j.LoggerFactory
import org.springframework.scheduling.annotation.Scheduled
import org.springframework.stereotype.Component
import java.time.LocalDateTime

@Slf4j
@Component
class ScheduledPushTask(
    private val webSocketHandler: WebSocketHandler,
    private val pushConfig: PushConfig
) {

    private val logger = LoggerFactory.getLogger(javaClass)

    /**
     * 定时推送任务（固定延迟，避免任务叠加）
     */
    @Scheduled(fixedDelayString = "#{@pushConfig.pushInterval}")
    fun pushMsgToClients() {
        // 增加日志，确认函数是否执行
//        logger.info("定时推送任务开始执行 - ${LocalDateTime.now()}")
        // 开关关闭时跳过
//        if (!pushConfig.pushEnabled.get()) {
//            return
//        }
        // 构造推送消息（适配前端格式）
        val msgObj = JSONObject()
        msgObj["content"] = "定时推送消息 - ${LocalDateTime.now()}"
        logger.debug("msgObj = ${msgObj}")
        // 广播给所有客户端
        webSocketHandler.broadcastMsg(msgObj.toJSONString())
    }
}