package com.inzy.wsmock.utils

import kotlin.math.atan2
import kotlin.math.cos
import kotlin.math.sin

object MyMapUtils {
    /**
     * 根据两个坐标点计算航向角
     * @param fromLon 起始点经度
     * @param fromLat 起始点纬度
     * @param toLon 终点经度
     * @param toLat 终点纬度
     * @return 航向角（度），范围 0-360
     */
    fun calculateBearing(fromLon: Double, fromLat: Double, toLon: Double, toLat: Double): Double {
        // 将度转换为弧度
        val lat1 = Math.toRadians(fromLat)
        val lat2 = Math.toRadians(toLat)
        val deltaLon = Math.toRadians(toLon - fromLon)

        // 计算航向角
        val y = sin(deltaLon) * cos(lat2)
        val x = cos(lat1) * sin(lat2) - sin(lat1) * cos(lat2) * cos(deltaLon)
        val bearing = Math.toDegrees(atan2(y, x))

        // 确保航向角在 0-360 度范围内
        return (bearing + 360) % 360
    }
}
