package com.inzy.wsmock

import com.alibaba.fastjson2.JSONObject
import com.inzy.wsmock.RequestParamHandler.Companion.PARAM_TYPE_KEY
import com.inzy.wsmock.RequestParamHandler.Companion.PARAM_TYPE_VALUE_1
import com.inzy.wsmock.RequestParamHandler.Companion.PARAM_TYPE_VALUE_2
import com.inzy.wsmock.RequestParamHandler.Companion.REQUEST_PARAMS_KEY
import com.inzy.wsmock.RequestParamHandler.Companion.REQUEST_PATH_KEY
import com.inzy.wsmock.utils.FileIoUtil
import io.netty.channel.Channel
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame
import jakarta.annotation.PostConstruct
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import org.slf4j.LoggerFactory
import org.springframework.core.io.ResourceLoader
import org.springframework.scheduling.annotation.Scheduled
import org.springframework.stereotype.Component
import java.time.LocalDateTime


@Component
class AdasPushTask(
    // 注入Spring资源加载器（Spring自动装配）
    private val resourceLoader: ResourceLoader
) {

    private val logger = LoggerFactory.getLogger(javaClass)

    // 注入ChannelManager单例
    private val channelManager = ChannelManager.instance

    //车辆位姿
    private var carDst = mutableListOf<String>()
    //感知物
    private var preDst = mutableListOf<String>()

    @PostConstruct
    fun readMockFile() {
        var classpathResource = resourceLoader.getResource("classpath:adasm/CarVehicle_fz.txt")
        // 读取文件内容（Kotlin简化写法）
        CoroutineScope(Dispatchers.IO).launch {
            FileIoUtil.getMockToList(classpathResource.inputStream, carDst)
//            println("读取到文件内容：${dst.count()}")
            classpathResource = resourceLoader.getResource("classpath:adasm/PerTarget.txt")
            FileIoUtil.getMockToList(classpathResource.inputStream, preDst)
        }
    }

    /**根据路径推送***/
    fun pushMsgFormPath(channel: Channel){
        var path: String = ""
        if (channel.hasAttr(REQUEST_PATH_KEY)) {
             path = channel.attr(REQUEST_PATH_KEY).get()
        }
        when (path) {
            "/ws/adas" -> {
                pushMsgFromTypeAdas(channel)
            }
         }
    }


    /**根据type推送**/
    private fun pushMsgFromTypeAdas(channel: Channel) {
        var type: String? = ""
        if (channel.hasAttr(REQUEST_PARAMS_KEY)) {
            val params = channel.attr(REQUEST_PARAMS_KEY).get()
            type = params.get(PARAM_TYPE_KEY)
        }
        when (type) {
            PARAM_TYPE_VALUE_1 -> {//车辆位姿
                if (carDst.isNotEmpty()){
                    CoroutineScope(Dispatchers.Default).launch {
                        delay(1000)
                        carDst.forEachIndexed { index, string ->
//                            println("index = ${index}")
                            sendMsg(channel,string)
                            delay(200)
                        }
                    }
                }
            }

            PARAM_TYPE_VALUE_2 -> {//感知物
                if (preDst.isNotEmpty()){
                    CoroutineScope(Dispatchers.Default).launch {
                        delay(2000)
                        preDst.forEachIndexed { index, string ->
//                            println("index = ${index}")
                            sendMsg(channel,string)
                            delay(500)
                        }
                    }
                }
            }

            else -> {
                val msg = JSONObject()
                msg.put("type", "adas")
                msg.put("data", "adas")
                sendMsg(channel, msg.toJSONString())
            }
        }
    }


    private fun sendMsg(channel: Channel, msg: String) {
        if (!channel.isActive()) {
//            println("无在线客户端，跳过推送")
            channelManager.removeChannel(channel)
            return
        }
        val clientId = channel.id().asShortText()
        val frame = TextWebSocketFrame(msg)
        channel.writeAndFlush(frame)
            .addListener { future ->
                if (!future.isSuccess) {
                    println("推送消息给客户端[$clientId]失败：${future.cause()?.message}")
                    channelManager.removeChannel(channel) // 推送失败移除失效Channel
                }
            }
    }


}