/*
 * Decompiled with CFR 0.152.
 */
package com.example.car_and_road_3d.models;

import com.example.car_and_road_3d.models.Position;
import org.json.JSONException;
import org.json.JSONObject;

public class Participant {
    private String participantId;
    private ParticipantType type;
    private Position position;
    private double headingAngle;

    public Participant() {
    }

    public Participant(String participantId, ParticipantType type, double latitude, double longitude, double headingAngle) {
        this(participantId, type, new Position(latitude, longitude), headingAngle);
    }

    public Participant(String participantId, ParticipantType type, Position position) {
        this(participantId, type, position, Math.PI);
    }

    public Participant(String participantId, ParticipantType type, Position position, double headingAngle) {
        this.participantId = participantId;
        this.type = type;
        this.position = position;
        this.headingAngle = headingAngle;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("ptcId", (Object)this.participantId);
        json.put("ptcType", (Object)this.type.getTypeCode());
        json.put("longitude", this.position.getLongitude());
        json.put("latitude", this.position.getLatitude());
        json.put("headingAngle", this.headingAngle);
        return json;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public void setType(ParticipantType type) {
        this.type = type;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public double getHeadingAngle() {
        return this.headingAngle;
    }

    public void setHeadingAngle(double headingAngle) {
        this.headingAngle = headingAngle;
    }

    public static enum ParticipantType {
        CAR("car"),
        PEOPLE("pedestrian");

        private final String typeCode;

        private ParticipantType(String typeCode) {
            this.typeCode = typeCode;
        }

        public String getTypeCode() {
            return this.typeCode;
        }
    }
}

