/*
 * Decompiled with CFR 0.152.
 */
package com.example.car_and_road_3d;

import android.util.Log;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.example.car_and_road_3d.CarAndRoadSetting;
import com.example.car_and_road_3d.models.Alarm;
import com.example.car_and_road_3d.models.EarlyMarker;
import com.example.car_and_road_3d.models.InitRoadRequest;
import com.example.car_and_road_3d.models.JavascriptCallbackData;
import com.example.car_and_road_3d.models.MainCar;
import com.example.car_and_road_3d.models.Participant;
import com.github.lzyzsd.jsbridge.BridgeHandler;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.github.lzyzsd.jsbridge.BridgeWebViewClient;
import com.github.lzyzsd.jsbridge.DefaultHandler;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import kotlin.text.Charsets;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CarAndRoadWebViewClient
extends BridgeWebViewClient {
    private final String TAG = "CAR_AND_ROAD_3D";
    private final String LOCAL_FILE_PREFIX = "https://www.dummy.com/";
    private final BridgeWebView webView;
    private volatile boolean hasInitialized = false;
    private volatile boolean hasMainCarInitialized = false;
    private final CarAndRoadSetting settings;
    private byte[] mainCarResource = null;
    private byte[] participantCarResource = null;
    private byte[] participantPeopleResource = null;

    public CarAndRoadWebViewClient(BridgeWebView webView) {
        this(webView, new CarAndRoadSetting());
    }

    public CarAndRoadWebViewClient(BridgeWebView webView, CarAndRoadSetting setting) {
        super(webView);
        this.webView = webView;
        this.settings = setting;
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setBuiltInZoomControls(this.settings.isShowZoomIcon());
        webView.getSettings().setAllowContentAccess(true);
        webView.getSettings().setMixedContentMode(0);
        webView.getSettings().setCacheMode(-1);
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setSupportZoom(this.settings.isSupportZooming());
        webView.setWebViewClient((WebViewClient)this);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if (CarAndRoadWebViewClient.this.settings.isShowJsConsoleLog()) {
                    Log.d((String)"CAR_AND_ROAD_3D", (String)("JS Console: " + consoleMessage.message()));
                }
                return true;
            }
        });
        webView.setDefaultHandler((BridgeHandler)new DefaultHandler());
        this.registerHandlers(webView);
        webView.loadUrl("file:///android_asset/web/index.html");
    }

    public void setDebugLogging(boolean enabled) {
        this.settings.setShowJsConsoleLog(enabled);
    }

    public void setWebViewLogging(boolean enabled) {
        this.settings.setEnableWebViewLogging(enabled);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        String url = request.getUrl().toString();
        if (url.contains("main/")) {
            byte[] array = url.contains("main_car_resource") ? this.mainCarResource : (url.contains("participant_car_resource") ? this.participantCarResource : this.participantPeopleResource);
            return new WebResourceResponse("application/octet-stream", Charsets.UTF_8.toString(), (InputStream)new ByteArrayInputStream(array));
        }
        if (url.startsWith("https://www.dummy.com/") && !url.contains("file:///")) {
            Log.i((String)"CAR_AND_ROAD_3D", (String)("Intercept request: " + request.getUrl()));
            String mimeType = "application/octet-stream";
            if (url.endsWith("png")) {
                mimeType = "image/png";
            } else if (url.endsWith("jpg") || url.endsWith("jpeg")) {
                mimeType = "image/jpeg";
            }
            try {
                return new WebResourceResponse(mimeType, Charsets.UTF_8.toString(), this.webView.getContext().getAssets().open("web/" + url.substring("https://www.dummy.com/".length())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.shouldInterceptRequest(view, request);
    }

    public void initCarAndRoad(InitRoadRequest request, Consumer<Boolean> completeCallback) {
        double[][] pos = new double[2][2];
        pos[0] = new double[]{request.getStartPosition().getLongitude(), request.getStartPosition().getLatitude()};
        pos[1] = new double[]{request.getEndPosition().getLongitude(), request.getEndPosition().getLatitude()};
        try {
            Gson gson = new Gson();
            String posStr = gson.toJson((Object)pos);
            this.logInfo("InitRoad: " + posStr);
            this.webView.callHandler("initializeRoadAndScene", posStr, data -> {
                this.logInfo("initCarAndRoad javascript callback received");
                JavascriptCallbackData callback = this.getCallbackData(data);
                this.hasInitialized = callback.isSuccess();
                if (completeCallback != null) {
                    completeCallback.accept(callback.isSuccess());
                }
            });
        }
        catch (Exception ex) {
            this.logException("Error in initCarAndRoad", ex);
        }
    }

    public synchronized void preloadMainCar(InputStream modelInputStream, Consumer<Boolean> completeEvent) {
        if (modelInputStream == null) {
            if (completeEvent != null) {
                completeEvent.accept(false);
            }
            return;
        }
        try {
            this.mainCarResource = IOUtils.toByteArray((InputStream)modelInputStream);
            if (completeEvent != null) {
                completeEvent.accept(true);
            }
        }
        catch (Exception ex) {
            if (completeEvent != null) {
                completeEvent.accept(false);
            }
            this.logException("\u9884\u52a0\u8f7d\u4e3b\u8f66\u5931\u8d25", ex);
        }
    }

    public synchronized void preloadParticipant(Participant.ParticipantType type, InputStream modelInputStream, Consumer<Boolean> completeEvent) {
        if (modelInputStream == null) {
            if (completeEvent != null) {
                completeEvent.accept(false);
            }
            return;
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)modelInputStream);
            if (type == Participant.ParticipantType.CAR) {
                this.participantCarResource = bytes;
            } else {
                this.participantPeopleResource = bytes;
            }
            if (completeEvent != null) {
                completeEvent.accept(true);
            }
        }
        catch (Exception ex) {
            if (completeEvent != null) {
                completeEvent.accept(false);
            }
            this.logException("\u9884\u52a0\u8f7d\u4e3b\u8f66\u5931\u8d25", ex);
        }
    }

    public void addMainCar(MainCar mainCar, Consumer<Boolean> completeEvent) {
        block5: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                JSONArray array = new JSONArray();
                array.put(mainCar.getPosition().getLongitude());
                array.put(mainCar.getPosition().getLatitude());
                jsonObject.put("position", (Object)array);
                jsonObject.put("headingAngle", mainCar.getHeadingAngle());
                if (mainCar.getLocalModelFile() != null) {
                    jsonObject.put("modelPath", (Object)mainCar.getLocalModelFile().getLocalFileName());
                } else if (this.mainCarResource != null) {
                    jsonObject.put("modelPath", (Object)"https://www.dummy.com//main/main_car_resource");
                }
                this.logInfo("addMainCar: [" + mainCar.getPosition().getLongitude() + ", " + mainCar.getPosition().getLatitude() + "]");
                this.webView.callHandler("addMainCar", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (JSONException ex) {
                this.logException("addMainCar: Failed to generate JSON object. {}", (Exception)((Object)ex));
                if (completeEvent == null) break block5;
                completeEvent.accept(false);
            }
        }
    }

    public void updateMainCar(MainCar mainCar, Consumer<Boolean> completeEvent) {
        block2: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                JSONArray array = new JSONArray();
                array.put(mainCar.getPosition().getLongitude());
                array.put(mainCar.getPosition().getLatitude());
                jsonObject.put("position", (Object)array);
                jsonObject.put("headingAngle", mainCar.getHeadingAngle());
                this.logInfo("updateMainCar: [" + mainCar.getPosition().getLongitude() + ", " + mainCar.getPosition().getLatitude() + "]");
                this.webView.callHandler("updateMainCar", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (JSONException ex) {
                this.logException("updateMainCar: Failed to generate JSON object. {}", (Exception)((Object)ex));
                if (completeEvent == null) break block2;
                completeEvent.accept(false);
            }
        }
    }

    public void refreshParticipants(List<Participant> participants, Consumer<Void> completeEvent) {
        try {
            JSONObject json = new JSONObject();
            JSONArray array = new JSONArray();
            participants.forEach(p -> {
                try {
                    array.put((Object)p.toJson());
                }
                catch (JSONException e) {
                    throw new RuntimeException("Failed to serialize participant", e);
                }
            });
            json.put("participants", (Object)array);
            if (this.participantCarResource != null) {
                json.put("car_file", (Object)"https://www.dummy.com//main/participant_car_resource");
            }
            if (this.participantPeopleResource != null) {
                json.put("people_file", (Object)"https://www.dummy.com//main/participant_people_resource");
            }
            this.webView.callHandler("refreshParticipants", json.toString(), data -> {
                if (completeEvent != null) {
                    completeEvent.accept(null);
                }
            });
        }
        catch (Exception ex) {
            this.logException("showRadar: Failed to generate JSON object. {}", ex);
            throw new RuntimeException("Exception in addMainCar.", ex);
        }
    }

    public void setAlarms(List<Alarm> alarms, @Nullable Consumer<Void> completeEvent) {
        if (alarms != null && !alarms.isEmpty()) {
            JSONArray array = new JSONArray();
            alarms.forEach(a -> {
                try {
                    JSONObject json = new JSONObject();
                    json.put("ptcId", (Object)a.getParticipantId());
                    json.put("status", a.isAlarm());
                    json.put("time", a.getTime() != null ? a.getTime() : 0);
                    array.put((Object)json);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            });
            this.webView.callHandler("setAlarms", array.toString(), data -> {
                if (completeEvent != null) {
                    completeEvent.accept(null);
                }
            });
        }
        if (completeEvent != null) {
            completeEvent.accept(null);
        }
    }

    public void setRoadColor(String color, @Nullable Consumer<Void> completeEvent) {
        if (color != null && !color.isEmpty()) {
            try {
                JSONObject json = new JSONObject();
                json.put("color", (Object)color);
                this.webView.callHandler("setRoadColor", json.toString(), data -> {
                    if (completeEvent != null) {
                        completeEvent.accept(null);
                    }
                });
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void setCameraPosition(double angle, @Nullable Consumer<Void> completeEvent) {
        try {
            JSONObject json = new JSONObject();
            json.put("angle", angle);
            this.webView.callHandler("setCameraPosition", json.toString(), data -> {
                if (completeEvent != null) {
                    completeEvent.accept(null);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setDistanceVisible(double distanceVisible, @Nullable Consumer<Void> completeEvent) {
        try {
            JSONObject json = new JSONObject();
            json.put("distanceVisible", distanceVisible);
            this.webView.callHandler("setDistanceVisible", json.toString(), data -> {
                if (completeEvent != null) {
                    completeEvent.accept(null);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void showRadar(boolean enabled, Consumer<Boolean> completeEvent) {
        block2: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("enabled", enabled);
                this.webView.callHandler("showRadar", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (Exception ex) {
                this.logException("showRadar: Failed to generate JSON object. {}", ex);
                if (completeEvent == null) break block2;
                completeEvent.accept(false);
            }
        }
    }

    public void showEarlyMarker(EarlyMarker earlyMarker, Consumer<Boolean> completeEvent) {
        block2: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", earlyMarker.getCode());
                this.webView.callHandler("drawEarlyMarker", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (Exception ex) {
                this.logException("showEarlyMarker: Failed to generate JSON object. {}", ex);
                if (completeEvent == null) break block2;
                completeEvent.accept(false);
            }
        }
    }

    public void showWarningCircle(boolean enabled, Consumer<Boolean> completeEvent) {
        block2: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("enabled", enabled);
                this.webView.callHandler("drawWarningCircle", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (Exception ex) {
                this.logException("drawWarningCircle: Failed to generate JSON object. {}", ex);
                if (completeEvent == null) break block2;
                completeEvent.accept(false);
            }
        }
    }

    public void showWalkLine(boolean enabled, Consumer<Boolean> completeEvent) {
        block2: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("enabled", enabled);
                this.webView.callHandler("drawWarkLine", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (Exception ex) {
                this.logException("showWalkLine: Failed to generate JSON object. {}", ex);
                if (completeEvent == null) break block2;
                completeEvent.accept(false);
            }
        }
    }

    public void clearAllTargets(Consumer<Boolean> completeEvent) {
        block2: {
            this.ensureInitialized();
            try {
                JSONObject jsonObject = new JSONObject();
                this.webView.callHandler("clearAllTarget", jsonObject.toString(), data -> {
                    JavascriptCallbackData callback = this.getCallbackData(data);
                    if (completeEvent != null) {
                        completeEvent.accept(callback.isSuccess());
                    }
                });
            }
            catch (Exception ex) {
                this.logException("clearAllTargets: Failed to generate JSON object. {}", ex);
                if (completeEvent == null) break block2;
                completeEvent.accept(false);
            }
        }
    }

    private void registerHandlers(BridgeWebView webView) {
        webView.registerHandler("initializeRoadAndScene", (data, function) -> {
            this.logInfo("handler = , data from web = " + data);
            function.onCallBack("Response from Java: " + data);
        });
    }

    private void ensureInitialized() {
        if (!this.hasInitialized) {
            throw new RuntimeException("\u9053\u8def\u6570\u636e\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initCarAndRoad \u5e76\u7b49\u5f85\u56de\u8c03\u5b8c\u6210\u3002");
        }
    }

    private JavascriptCallbackData getCallbackData(String data) {
        try {
            JSONObject json = new JSONObject(data);
            JavascriptCallbackData callback = new JavascriptCallbackData(json.optBoolean("success"), json.opt("data"), json.optString("errorMessage", null));
            if (!callback.isSuccess()) {
                this.logException("Javascript \u8c03\u7528\u5931\u8d25\u3002", callback.getErrorMessage());
            }
            return callback;
        }
        catch (JSONException ex) {
            this.logException("Failed to deserialize callback data from Javascript.", (Exception)((Object)ex));
            return new JavascriptCallbackData(ex.getMessage());
        }
    }

    private void logInfo(String message) {
        if (this.settings.isEnableWebViewLogging()) {
            Log.i((String)"CAR_AND_ROAD_3D", (String)message);
        }
    }

    private void logException(String message, Exception ex) {
        Log.e((String)"CAR_AND_ROAD_3D", (String)message, (Throwable)ex);
    }

    private void logException(String message, String exceptionMessage) {
        Log.e((String)"CAR_AND_ROAD_3D", (String)(message + ": " + exceptionMessage));
    }

    private void waitForSceneInitializedSync() {
        int times = 0;
        while (times < 30 && !this.hasInitialized) {
            this.logInfo("Busy waiting " + ++times);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

