/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.unity3d.player.A;
import com.unity3d.player.A0;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.B;
import com.unity3d.player.B0;
import com.unity3d.player.C0;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.D0;
import com.unity3d.player.E0;
import com.unity3d.player.F0;
import com.unity3d.player.G0;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.H0;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.I0;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.J0;
import com.unity3d.player.K0;
import com.unity3d.player.L0;
import com.unity3d.player.M0;
import com.unity3d.player.MultiWindowSupport;
import com.unity3d.player.N0;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.NetworkConnectivity;
import com.unity3d.player.NetworkConnectivityNougat;
import com.unity3d.player.O;
import com.unity3d.player.OrientationLockListener;
import com.unity3d.player.P0;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.Q0;
import com.unity3d.player.R0;
import com.unity3d.player.UnityPermissions;
import com.unity3d.player.a.e;
import com.unity3d.player.a.f;
import com.unity3d.player.c1;
import com.unity3d.player.d0;
import com.unity3d.player.d1;
import com.unity3d.player.f0;
import com.unity3d.player.g0;
import com.unity3d.player.h0;
import com.unity3d.player.j0;
import com.unity3d.player.k0;
import com.unity3d.player.l0;
import com.unity3d.player.n0;
import com.unity3d.player.o0;
import com.unity3d.player.p0;
import com.unity3d.player.q0;
import com.unity3d.player.r0;
import com.unity3d.player.s0;
import com.unity3d.player.t0;
import com.unity3d.player.u;
import com.unity3d.player.u0;
import com.unity3d.player.v0;
import com.unity3d.player.w;
import com.unity3d.player.w0;
import com.unity3d.player.x0;
import com.unity3d.player.y0;
import com.unity3d.player.z;
import com.unity3d.player.z0;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class UnityPlayer
extends FrameLayout
implements IUnityPlayerLifecycleEvents {
    public static Activity currentActivity;
    public static Context currentContext;
    private static final int RUN_STATE_CHANGED_MSG_CODE = 2269;
    private static final String SPLASH_ENABLE_METADATA_NAME = "unity.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "unity.splash-mode";
    private static final String LAUNCH_FULLSCREEN = "unity.launch-fullscreen";
    private static final String ARCORE_ENABLE_METADATA_NAME = "unity.arcore-enable";
    private static final String AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME = "unity.auto-report-fully-drawn";
    Handler mHandler;
    private int mInitialScreenOrientation;
    private boolean mMainDisplayOverride;
    private boolean mIsFullscreen;
    private R0 mState;
    private final ConcurrentLinkedQueue m_Events;
    private OrientationEventListener mOrientationListener;
    private int mNaturalOrientation;
    private Configuration prevConfig;
    P0 m_MainThread;
    private boolean m_AddPhoneCallListener;
    private M0 m_PhoneCallListener;
    private TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private f m_SplashScreen;
    private GoogleARCoreApi m_ARCoreApi;
    private L0 m_FakeListener;
    private Camera2Wrapper m_Camera2Wrapper;
    private HFPStatus m_HFPStatus;
    private AudioVolumeHandler m_AudioVolumeHandler;
    private OrientationLockListener m_OrientationLockListener;
    private Uri m_launchUri;
    private NetworkConnectivity m_NetworkConnectivity;
    private z m_OnBackPressedDispatcher;
    private IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents;
    private int m_IsNoWindowMode;
    Window m_Window;
    private long mSoftInputTimeoutMilliSeconds;
    private B mOnHandleFocusListener;
    private Context mContext;
    private Activity mActivity;
    private f0 mGlView;
    private boolean mQuitting;
    private boolean mProcessKillRequested;
    private d1 mVideoPlayerProxy;
    O mSoftInput;

    public UnityPlayer(Context context) {
        this(context, null);
    }

    public UnityPlayer(Context object, IUnityPlayerLifecycleEvents object2) {
        super(object);
        D0 d02;
        HFPStatus hFPStatus;
        Camera2Wrapper camera2Wrapper;
        f0 f02;
        L0 l02;
        M0 m02;
        P0 p02;
        ConcurrentLinkedQueue concurrentLinkedQueue;
        R0 r02;
        Handler handler;
        Object object3 = handler;
        handler = new Handler();
        this.mHandler = object3;
        this.mInitialScreenOrientation = -1;
        this.mMainDisplayOverride = false;
        this.mIsFullscreen = true;
        object3 = r02;
        r02 = new R0();
        this.mState = object3;
        object3 = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        this.m_Events = object3;
        this.mOrientationListener = null;
        object3 = p02;
        p02 = new P0(this);
        this.m_MainThread = object3;
        this.m_AddPhoneCallListener = false;
        object3 = m02;
        m02 = new M0(this);
        this.m_PhoneCallListener = object3;
        this.m_ARCoreApi = null;
        object3 = l02;
        l02 = new L0();
        this.m_FakeListener = object3;
        this.m_Camera2Wrapper = null;
        this.m_HFPStatus = null;
        this.m_AudioVolumeHandler = null;
        this.m_OrientationLockListener = null;
        this.m_launchUri = null;
        this.m_NetworkConnectivity = null;
        this.m_OnBackPressedDispatcher = null;
        this.m_UnityPlayerLifecycleEvents = null;
        this.m_IsNoWindowMode = -1;
        this.mSoftInputTimeoutMilliSeconds = 1000L;
        this.mProcessKillRequested = true;
        this.mSoftInput = null;
        if (object2 == null) {
            object2 = this;
        }
        Context context = object;
        this.m_UnityPlayerLifecycleEvents = object2;
        d0.a(UnityPlayer.getUnityNativeLibraryPath(context));
        currentContext = context;
        if (context instanceof Activity) {
            currentActivity = this.mActivity = (Activity)object;
            this.mInitialScreenOrientation = this.mActivity.getRequestedOrientation();
            this.m_launchUri = this.mActivity.getIntent().getData();
        }
        this.mContext = object;
        this.EarlyEnableFullScreenIfEnabled();
        this.prevConfig = this.getResources().getConfiguration();
        this.mNaturalOrientation = this.getNaturalOrientation(this.prevConfig.orientation);
        if (this.mActivity != null && this.getSplashEnabled()) {
            f f2;
            object2 = f2;
            f2 = new f(this.mContext, e.a()[this.getSplashMode()]);
            this.m_SplashScreen = object2;
            this.addView((View)object2);
        }
        UnityPlayer.preloadJavaPlugins();
        object2 = UnityPlayer.loadNative(UnityPlayer.getUnityNativeLibraryPath(this.mContext));
        if (!R0.d()) {
            t0 t02;
            w.Log(6, "Your hardware does not support this application.");
            object = t02;
            t02 = new t0(this);
            AlertDialog alertDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", (DialogInterface.OnClickListener)object).setMessage((CharSequence)("Your hardware does not support this application.\n\n" + (String)object2 + "\n\n Press OK to quit.")).create();
            alertDialog.setCancelable(false);
            alertDialog.show();
            return;
        }
        this.initJni((Context)object);
        this.mState.d(true);
        object2 = f02;
        f02 = new f0((Context)object, this);
        this.mGlView = object2;
        this.addView((View)object2);
        this.bringChildToFront(this.m_SplashScreen);
        this.mQuitting = false;
        object = this.mActivity;
        if (object != null) {
            this.m_Window = object.getWindow();
        }
        this.hideStatusBar();
        this.m_TelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.m_ClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        object = camera2Wrapper;
        camera2Wrapper = new Camera2Wrapper(this.mContext);
        this.m_Camera2Wrapper = object;
        object = hFPStatus;
        hFPStatus = new HFPStatus(this.mContext);
        this.m_HFPStatus = object;
        this.m_MainThread.start();
        object = d02;
        d02 = new D0(this);
        this.m_OnBackPressedDispatcher = A.a(this.mActivity, 1, (Runnable)object);
    }

    private int getNaturalOrientation(int n2) {
        int n3 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n3 != 0 && n3 != 2 || n2 != 2) && (n3 != 1 && n3 != 3 || n2 != 1)) {
            return 1;
        }
        return 0;
    }

    private String GetGlViewContentDescription(Context context) {
        String string = context.getPackageName();
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", string));
    }

    private void DisableStaticSplashScreen() {
        E0 e02;
        E0 e03 = e02;
        e02 = new E0(this);
        this.runOnUiThread(e03);
    }

    private void EarlyEnableFullScreenIfEnabled() {
        Activity activity = this.mActivity;
        if (activity != null && activity.getWindow() != null && (this.getLaunchFullscreen() || this.mActivity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false)) && (activity = this.mActivity.getWindow().getDecorView()) != null) {
            activity.setSystemUiVisibility(7);
        }
        u.a(this.mActivity);
    }

    private boolean IsWindowTranslucent() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer == null) {
            return false;
        }
        unityPlayer = unityPlayer.getTheme().obtainStyledAttributes(new int[]{16842840});
        boolean bl = unityPlayer.getBoolean(0, false);
        unityPlayer.recycle();
        return bl;
    }

    private boolean updateDisplayInternal(int n2, Surface surface) {
        String string = "Timeout (";
        if (R0.d() && ((UnityPlayer)object).mState.a()) {
            block14: {
                Object object;
                G0 g02;
                Semaphore semaphore;
                Semaphore semaphore2 = semaphore;
                semaphore = new Semaphore(0);
                G0 g03 = g02;
                g02 = new G0((UnityPlayer)object, n2, surface, semaphore2);
                if (n2 == 0) {
                    if (surface == null) {
                        object = ((UnityPlayer)object).m_MainThread;
                        if (((P0)object).a != null) {
                            Object object2 = object;
                            ((P0)object2).a(N0.d);
                            Message.obtain((Handler)((P0)object2).a, (Runnable)g03).sendToTarget();
                        }
                    } else {
                        object = ((UnityPlayer)object).m_MainThread;
                        Handler handler = ((P0)object).a;
                        if (handler != null) {
                            Message.obtain((Handler)handler, (Runnable)g03).sendToTarget();
                            ((P0)object).a(N0.e);
                        }
                    }
                } else {
                    g03.run();
                }
                if (surface == null && n2 == 0) {
                    Semaphore semaphore3 = semaphore2;
                    object = SynchronizationTimeout.SurfaceDetach;
                    long l2 = ((SynchronizationTimeout)((Object)object)).getTimeout();
                    if (semaphore3.tryAcquire(l2, TimeUnit.MILLISECONDS)) break block14;
                    try {
                        w.Log(5, string + ((SynchronizationTimeout)((Object)object)).getTimeout() + " ms) while trying detaching primary window.");
                    }
                    catch (InterruptedException interruptedException) {
                        w.Log(5, "UI thread got interrupted while trying to detach the primary window from the Unity Engine.");
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void UnitySendMessage(String string, String string2, String string3) {
        if (!R0.d()) {
            w.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, string3.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void finish() {
        Activity activity = this.mActivity;
        if (activity != null && !activity.isFinishing()) {
            this.mActivity.finish();
        }
    }

    private void queueDestroy() {
        I0 i02;
        w.Log(4, "Queue Destroy");
        I0 i03 = i02;
        i02 = new I0(this);
        this.runOnUiThread(i03);
    }

    private void pauseUnity() {
        UnityPlayer unityPlayer = this;
        String string = "Timeout (";
        unityPlayer.reportSoftInputStr(null, 1, true);
        Object object = unityPlayer.m_OnBackPressedDispatcher;
        if (object != null) {
            boolean bl = ((z)object).a != null;
            ((z)object).c = bl;
            ((z)object).unregisterOnBackPressedCallback();
        }
        if (this.mState.c() && !this.mState.b()) {
            block13: {
                if (R0.d()) {
                    Runnable runnable;
                    Semaphore semaphore;
                    object = semaphore;
                    semaphore = new Semaphore(0);
                    if (this.isFinishing()) {
                        J0 j02;
                        runnable = j02;
                        j02 = new J0(this, (Semaphore)object);
                    } else {
                        K0 k02;
                        runnable = k02;
                        k02 = new K0(this, (Semaphore)object);
                    }
                    P0 p02 = this.m_MainThread;
                    if (p02.a != null) {
                        P0 p03 = p02;
                        p03.a(N0.a);
                        Message.obtain((Handler)p03.a, (Runnable)runnable).sendToTarget();
                    }
                    Object object2 = object;
                    object = SynchronizationTimeout.Pause;
                    long l2 = ((SynchronizationTimeout)((Object)object)).getTimeout();
                    if (((Semaphore)object2).tryAcquire(l2, TimeUnit.MILLISECONDS)) break block13;
                    try {
                        w.Log(5, string + ((SynchronizationTimeout)((Object)object)).getTimeout() + " ms) while trying to pause the Unity Engine.");
                    }
                    catch (InterruptedException interruptedException) {
                        w.Log(5, "UI thread got interrupted while trying to pause the Unity Engine.");
                    }
                }
            }
            UnityPlayer unityPlayer2 = this;
            unityPlayer2.mState.c(false);
            unityPlayer2.mState.e(true);
            if (unityPlayer2.m_AddPhoneCallListener) {
                this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 0);
            }
            return;
        }
    }

    private void shutdown() {
        UnityPlayer unityPlayer = this;
        unityPlayer.mProcessKillRequested = unityPlayer.nativeDone();
        unityPlayer.mState.d(false);
    }

    private void checkResumePlayer() {
        boolean bl = false;
        Activity activity = this.mActivity;
        if (activity != null) {
            bl = MultiWindowSupport.isInMultiWindowMode(activity);
        }
        if (!this.mState.a(bl)) {
            return;
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.c(true);
        unityPlayer.queueGLThreadEvent(new h0(this));
        unityPlayer.m_MainThread.a(N0.b);
    }

    private void raiseFocusListener(boolean bl) {
        Object object = ((UnityPlayer)object).mOnHandleFocusListener;
        if (object != null) {
            object = ((l0)object).a;
            ((n0)object).b = true;
            if (((n0)object).a) {
                ((n0)object).c.release();
            }
        }
    }

    private final native void initJni(Context var1);

    private final native boolean nativeRender();

    private final native void nativeSetInputArea(int var1, int var2, int var3, int var4);

    private final native void nativeSetKeyboardIsVisible(boolean var1);

    private final native void nativeSetInputString(String var1);

    private final native void nativeSetInputSelection(int var1, int var2);

    private final native void nativeSoftInputCanceled();

    private final native void nativeSoftInputLostFocus();

    private final native void nativeReportKeyboardConfigChanged();

    private final native boolean nativePause();

    private final native void nativeResume();

    private final native void nativeLowMemory();

    private final native void nativeApplicationUnload();

    private final native void nativeFocusChanged(boolean var1);

    private final native void nativeRecreateGfxState(int var1, Surface var2);

    private final native void nativeSendSurfaceChangedEvent();

    private final native boolean nativeDone();

    private final native void nativeSoftInputClosed();

    private final native boolean nativeInjectEvent(InputEvent var1, int var2);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeRestartActivityIndicator();

    private final native void nativeSetLaunchURL(String var1);

    private final native void nativeOrientationChanged(int var1, int var2);

    private final native boolean nativeGetNoWindowMode();

    private final native void nativeHidePreservedContent();

    private static String logLoadLibMainError(String string, String string2) {
        String string3 = "Failed to load 'libmain.so'\n\n" + string2;
        w.Log(6, string3);
        return string3;
    }

    private static void preloadJavaPlugins() {
        try {
            Class.forName("com.unity3d.JavaPluginPreloader");
        }
        catch (LinkageError linkageError) {
            w.Log(6, "Java class preloading failed: " + linkageError.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadNative(String var0) {
        var1_1 = var0 + "/libmain.so";
        try {
            System.load(var1_1);
            ** GOTO lbl12
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                System.loadLibrary("main");
            }
            catch (SecurityException v1) {
                return UnityPlayer.logLoadLibMainError(var1_1, v1.toString());
            }
lbl12:
            // 2 sources

            if (NativeLoader.load(var0)) {
                R0.e();
                return "";
            }
            w.Log(6, "NativeLoader.load failure, Unity libraries were not loaded.");
            return "NativeLoader.load failure, Unity libraries were not loaded.";
            catch (UnsatisfiedLinkError v2) {
                return UnityPlayer.logLoadLibMainError(var1_1, v2.toString());
            }
        }
    }

    private static void unloadNative() {
        if (!R0.d()) {
            return;
        }
        if (NativeLoader.unload()) {
            R0.f();
            return;
        }
        throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
    }

    private static String getUnityNativeLibraryPath(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    private long getSoftInputTimeout() {
        UnityPlayer unityPlayer = this;
        double d2 = Math.max(1.0f, Settings.System.getFloat((ContentResolver)unityPlayer.mContext.getContentResolver(), (String)"animator_duration_scale", (float)0.0f));
        return Math.round((double)unityPlayer.mSoftInputTimeoutMilliSeconds * d2);
    }

    private void dismissSoftInput() {
        O o2 = this.mSoftInput;
        if (o2 != null) {
            o2.c();
            this.nativeReportKeyboardConfigChanged();
        }
    }

    private void hidePreservedContent() {
        k0 k02;
        k0 k03 = k02;
        k02 = new k0(this);
        this.runOnUiThread(k03);
    }

    private String getProcessName() {
        int n2 = Process.myPid();
        Object object = ((ActivityManager)this.mContext.getSystemService("activity")).getRunningAppProcesses();
        if (object == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            if (runningAppProcessInfo.pid != n2) continue;
            return runningAppProcessInfo.processName;
        }
        return null;
    }

    private ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    private ActivityInfo getActivityInfo() {
        return this.mActivity.getPackageManager().getActivityInfo(this.mActivity.getComponentName(), 128);
    }

    private boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getARCoreEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(ARCORE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getLaunchFullscreen() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(LAUNCH_FULLSCREEN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getHaveAndroidWindowSupport() {
        if (this.m_IsNoWindowMode == -1) {
            this.m_IsNoWindowMode = this.nativeGetNoWindowMode() ? 1 : 0;
        }
        return this.m_IsNoWindowMode == 1;
    }

    private boolean getAutoReportFullyDrawnEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void queueGLThreadEvent(Q0 q02) {
        if (this.isFinishing()) {
            return;
        }
        this.queueGLThreadEvent((Runnable)q02);
    }

    private void hideStatusBar() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            unityPlayer.getWindow().setFlags(1024, 1024);
        }
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.b()) {
            this.setupUnityToBePaused();
            bl = true;
        }
        if (!(view == null || (viewParent = view.getParent()) instanceof UnityPlayer && (UnityPlayer)viewParent == this)) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            UnityPlayer unityPlayer = this;
            unityPlayer.addView(view);
            unityPlayer.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == this) {
            view2.setVisibility(8);
            this.removeView(view2);
        }
        if (bl) {
            this.setupUnityToBeResumed();
        }
    }

    private void setBackButtonLeavesApp(boolean bl) {
        z z2 = ((UnityPlayer)((Object)z2)).m_OnBackPressedDispatcher;
        if (z2 != null) {
            if (bl ^ true) {
                z2.registerOnBackPressedCallback();
            } else {
                z2.unregisterOnBackPressedCallback();
            }
        }
    }

    static {
        new d0().a();
    }

    Activity getActivity() {
        return this.mActivity;
    }

    public void setOnHandleFocusListener(B b2) {
        this.mOnHandleFocusListener = b2;
    }

    @Override
    public void onUnityPlayerUnloaded() {
    }

    @Override
    public void onUnityPlayerQuitted() {
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
        } else {
            sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
        }
    }

    void sendSurfaceChangedEvent() {
        if (R0.d() && unityPlayer.mState.a()) {
            F0 f02;
            F0 f03 = f02;
            f02 = new F0(unityPlayer);
            UnityPlayer unityPlayer = unityPlayer.m_MainThread.a;
            if (unityPlayer != null) {
                Message.obtain((Handler)unityPlayer, (Runnable)f03).sendToTarget();
            }
            return;
        }
    }

    void updateGLDisplay(int n2, Surface surface) {
        if (this.mMainDisplayOverride) {
            return;
        }
        this.updateDisplayInternal(n2, surface);
    }

    public boolean displayChanged(int n2, Surface surface) {
        if (n2 == 0) {
            H0 h02;
            boolean bl = surface != null;
            this.mMainDisplayOverride = bl;
            H0 h03 = h02;
            h02 = new H0(this);
            this.runOnUiThread(h03);
        }
        return this.updateDisplayInternal(n2, surface);
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        Activity activity = this.mActivity;
        if (activity != null) {
            activity.runOnUiThread(runnable);
        } else if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public void init(int n2, boolean bl) {
    }

    public View getView() {
        return this;
    }

    public Bundle getSettings() {
        return Bundle.EMPTY;
    }

    public void quit() {
        this.destroy();
    }

    public void newIntent(Intent intent) {
        this.m_launchUri = intent.getData();
        this.m_MainThread.a(N0.i);
    }

    public void destroy() {
        Object object = this.m_Camera2Wrapper;
        if (object != null) {
            ((Camera2Wrapper)object).a();
            this.m_Camera2Wrapper = null;
        }
        if ((object = this.m_HFPStatus) != null) {
            ((HFPStatus)object).b();
            this.m_HFPStatus = null;
        }
        if ((object = this.m_NetworkConnectivity) != null) {
            ((NetworkConnectivity)((Object)object)).a();
            this.m_NetworkConnectivity = null;
        }
        if ((object = this.m_OnBackPressedDispatcher) != null) {
            ((z)object).unregisterOnBackPressedCallback();
            this.m_OnBackPressedDispatcher = null;
        }
        this.mQuitting = true;
        if (!this.mState.b()) {
            this.setupUnityToBePaused();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.m_MainThread.a(N0.c);
        P0 p02 = unityPlayer.m_MainThread;
        long l2 = SynchronizationTimeout.Destroy.getTimeout();
        try {
            p02.join(l2);
        }
        catch (InterruptedException interruptedException) {
            this.m_MainThread.interrupt();
        }
        if (R0.d()) {
            this.removeAllViews();
        }
        if (this.mProcessKillRequested) {
            UnityPlayer unityPlayer2 = this;
            unityPlayer2.m_UnityPlayerLifecycleEvents.onUnityPlayerQuitted();
            unityPlayer2.kill();
        }
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        Process.killProcess((int)Process.myPid());
    }

    public void onStop() {
        if (!MultiWindowSupport.isInMultiWindowMode(this.mActivity)) {
            return;
        }
        this.setupUnityToBePaused();
    }

    public void onStart() {
        if (!MultiWindowSupport.isInMultiWindowMode(this.mActivity)) {
            return;
        }
        this.setupUnityToBeResumed();
    }

    public void onPause() {
        UnityPlayer unityPlayer = this;
        MultiWindowSupport.saveMultiWindowMode(unityPlayer.mActivity);
        if (MultiWindowSupport.isInMultiWindowMode(unityPlayer.mActivity)) {
            return;
        }
        this.setupUnityToBePaused();
    }

    public void onResume() {
        if (MultiWindowSupport.isInMultiWindowMode(this.mActivity) && !MultiWindowSupport.isMultiWindowModeChangedToTrue(this.mActivity)) {
            return;
        }
        this.setupUnityToBeResumed();
    }

    public void pause() {
        this.setupUnityToBePaused();
    }

    protected void setupUnityToBePaused() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).pauseARCore();
        }
        if ((object = this.mVideoPlayerProxy) != null) {
            ((d1)object).b();
        }
        if ((object = this.m_AudioVolumeHandler) != null) {
            ((AudioVolumeHandler)object).a();
            this.m_AudioVolumeHandler = null;
        }
        if ((object = this.m_OrientationLockListener) != null) {
            ((OrientationLockListener)object).a();
            this.m_OrientationLockListener = null;
        }
        this.pauseUnity();
    }

    public void resume() {
        this.setupUnityToBeResumed();
    }

    protected void setupUnityToBeResumed() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).resumeARCore();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.e(false);
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((d1)object).c();
        }
        this.checkResumePlayer();
        if (R0.d()) {
            this.nativeRestartActivityIndicator();
        }
        if (this.m_AudioVolumeHandler == null) {
            this.m_AudioVolumeHandler = new AudioVolumeHandler(this.mContext);
        }
        if (this.m_OrientationLockListener == null && R0.d()) {
            this.m_OrientationLockListener = new OrientationLockListener(this.mContext);
        }
        if ((object = this.m_OnBackPressedDispatcher) != null && ((z)object).c) {
            ((z)object).registerOnBackPressedCallback();
        }
        this.prevConfig = this.getResources().getConfiguration();
    }

    public void lowMemory() {
        g0 g02;
        if (!R0.d()) {
            return;
        }
        g0 g03 = g02;
        g02 = new g0(this);
        this.queueGLThreadEvent(g03);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    protected boolean skipPermissionsDialog() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            return UnityPermissions.skipPermissionsDialog((Activity)unityPlayer);
        }
        return false;
    }

    protected void requestUserAuthorization(String string) {
        if (string != null && !string.isEmpty() && this.mActivity != null) {
            UnityPermissions.ModalWaitForPermissionResponse modalWaitForPermissionResponse;
            UnityPermissions.ModalWaitForPermissionResponse modalWaitForPermissionResponse2 = modalWaitForPermissionResponse;
            modalWaitForPermissionResponse2();
            UnityPermissions.requestUserPermissions(this.mActivity, new String[]{string}, modalWaitForPermissionResponse2);
            modalWaitForPermissionResponse.waitForResponse();
        }
    }

    protected int getNetworkConnectivity() {
        NetworkConnectivity networkConnectivity = this.m_NetworkConnectivity;
        if (networkConnectivity != null) {
            return networkConnectivity.b();
        }
        this.m_NetworkConnectivity = PlatformSupport.NOUGAT_SUPPORT ? new NetworkConnectivityNougat(this.mContext) : new NetworkConnectivity(this.mContext);
        return this.m_NetworkConnectivity.b();
    }

    public void configurationChanged(Configuration configuration) {
        Configuration configuration2;
        int n2 = ((UnityPlayer)object).prevConfig.diff(configuration);
        if ((n2 & 0x100) != 0 || (n2 & 0x400) != 0 || (n2 & 0x800) != 0 || (n2 & 0x80) != 0) {
            ((UnityPlayer)object).nativeHidePreservedContent();
        }
        UnityPlayer unityPlayer = object;
        Object object = configuration2;
        configuration2 = new Configuration(configuration);
        unityPlayer.prevConfig = object;
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((d1)object).a();
        }
    }

    public void windowFocusChanged(boolean bl) {
        O o2;
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.b(bl);
        if (unityPlayer.mState.a() && ((o2 = this.mSoftInput) == null || o2.d())) {
            if (bl) {
                this.m_MainThread.a(N0.g);
            } else {
                this.m_MainThread.a(N0.f);
            }
            UnityPlayer unityPlayer2 = this;
            unityPlayer2.raiseFocusListener(bl);
            unityPlayer2.checkResumePlayer();
            return;
        }
        this.raiseFocusListener(bl);
    }

    protected boolean loadLibrary(String string) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    protected void showSoftInput(String string, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, int n3, boolean bl5, boolean bl6) {
        block4: {
            Semaphore semaphore;
            String string3 = "Timeout (";
            Semaphore semaphore2 = semaphore;
            UnityPlayer unityPlayer = this;
            semaphore2(0);
            UnityPlayer unityPlayer2 = this;
            unityPlayer.postOnUiThread(new j0(unityPlayer2, unityPlayer2, string, n2, bl, bl2, bl3, bl4, string2, n3, bl5, bl6, semaphore2));
            if (semaphore.tryAcquire(unityPlayer.getSoftInputTimeout(), TimeUnit.MILLISECONDS)) break block4;
            try {
                w.Log(6, string3 + this.getSoftInputTimeout() + " ms) while waiting softinput showing operation.");
            }
            catch (InterruptedException interruptedException) {
                w.Log(6, "UI thread got interrupted while waiting softinput showing operation.");
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void hideSoftInput() {
        Throwable throwable2;
        block8: {
            block7: {
                Semaphore semaphore;
                String string = "Timeout (";
                if (this.mSoftInput == null) {
                    return;
                }
                UnityPlayer unityPlayer = this;
                unityPlayer.reportSoftInputArea(new Rect());
                unityPlayer.reportSoftInputIsVisible(false);
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    this.dismissSoftInput();
                    this.mSoftInput = null;
                    return;
                }
                Semaphore semaphore2 = semaphore;
                UnityPlayer unityPlayer2 = this;
                semaphore2(0);
                unityPlayer2.postOnUiThread(new n0(this, semaphore2, this));
                if (semaphore.tryAcquire(unityPlayer2.getSoftInputTimeout(), TimeUnit.MILLISECONDS)) break block7;
                int n2 = 6;
                {
                    catch (Throwable throwable2) {
                        break block8;
                    }
                    catch (InterruptedException interruptedException) {}
                    {
                        w.Log(6, "UI thread got interrupted while waiting softinput hiding operation.");
                        this.mSoftInput = null;
                        return;
                    }
                }
                {
                    w.Log(n2, string + this.getSoftInputTimeout() + " ms) while waiting softinput hiding operation.");
                }
            }
            this.mSoftInput = null;
            return;
        }
        this.mSoftInput = null;
        throw throwable2;
    }

    protected void setSoftInputStr(String string) {
        o0 o02;
        o0 o03 = o02;
        o02 = new o0(this, string);
        this.runOnUiThread(o03);
    }

    protected void setCharacterLimit(int n2) {
        p0 p02;
        p0 p03 = p02;
        p02 = new p0(this, n2);
        this.runOnUiThread(p03);
    }

    protected void setHideInputField(boolean bl) {
        q0 q02;
        q0 q03 = q02;
        q02 = new q0(this, bl);
        this.runOnUiThread(q03);
    }

    protected void setSelection(int n2, int n3) {
        r0 r02;
        r0 r03 = r02;
        r02 = new r0(this, n2, n3);
        this.runOnUiThread(r03);
    }

    protected String getKeyboardLayout() {
        O o2 = ((UnityPlayer)((Object)o2)).mSoftInput;
        if (o2 == null) {
            return null;
        }
        return o2.a();
    }

    protected void reportSoftInputStr(String string, int n2, boolean bl) {
        s0 s02;
        if (n2 == 1) {
            this.hideSoftInput();
        }
        s0 s03 = s02;
        s02 = new s0(this, bl, string, n2);
        this.queueGLThreadEvent(s03);
    }

    protected void reportSoftInputSelection(int n2, int n3) {
        u0 u02;
        u0 u03 = u02;
        u02 = new u0(this, n2, n3);
        this.queueGLThreadEvent(u03);
    }

    protected void reportSoftInputArea(Rect rect) {
        v0 v02;
        v0 v03 = v02;
        v02 = new v0(this, rect);
        this.queueGLThreadEvent(v03);
    }

    protected void reportSoftInputIsVisible(boolean bl) {
        w0 w02;
        w0 w03 = w02;
        w02 = new w0(this, bl);
        this.queueGLThreadEvent(w03);
    }

    protected void setClipboardText(String string) {
        UnityPlayer unityPlayer = unityPlayer2;
        UnityPlayer unityPlayer2 = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        unityPlayer.m_ClipboardManager.setPrimaryClip((ClipData)unityPlayer2);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        UnityPlayer unityPlayer = unityPlayer.m_launchUri;
        return unityPlayer != null ? unityPlayer.toString() : null;
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && this.mActivity != null && this.getARCoreEnabled()) {
            GoogleARCoreApi googleARCoreApi;
            GoogleARCoreApi googleARCoreApi2;
            GoogleARCoreApi googleARCoreApi3 = googleARCoreApi2 = googleARCoreApi;
            googleARCoreApi3();
            this.m_ARCoreApi = googleARCoreApi3;
            googleARCoreApi.initializeARCore(this.mActivity);
            if (!this.mState.b()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean showVideoPlayer(String string, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        x0 x02;
        if (this.mVideoPlayerProxy == null) {
            d1 d12;
            d1 d13 = d12;
            d12 = new d1(this);
            this.mVideoPlayerProxy = d13;
        }
        Object object = this.mContext;
        long l2 = n5;
        long l3 = n6;
        Context context = object;
        object = x02;
        x02 = new x0(this);
        boolean bl2 = this.mVideoPlayerProxy.a(context, string, n2, n3, n4, bl, l2, l3, (c1)object);
        if (bl2) {
            y0 y02;
            y0 y03 = y02;
            y02 = new y0(this);
            this.runOnUiThread(y03);
        }
        return bl2;
    }

    protected void pauseJavaAndCallUnloadCallback() {
        z0 z02;
        z0 z03 = z02;
        z02 = new z0(this);
        this.runOnUiThread(z03);
    }

    protected boolean isUaaLUseCase() {
        Object object = this.mActivity;
        if (object != null) {
            return (object = object.getCallingPackage()) != null && ((String)object).equals(this.mContext.getPackageName());
        }
        return false;
    }

    protected int getUaaLLaunchProcessType() {
        String string = this.getProcessName();
        return string != null && !string.equals(this.mContext.getPackageName()) ? 1 : 0;
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void executeGLThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_Events.poll()) != null) {
            runnable.run();
        }
    }

    protected void disableLogger() {
        w.a = true;
    }

    void queueGLThreadEvent(Runnable runnable) {
        if (!R0.d()) {
            return;
        }
        if (Thread.currentThread() == this.m_MainThread) {
            runnable.run();
        } else {
            this.m_Events.add(runnable);
        }
    }

    protected boolean isFinishing() {
        if (this.mQuitting) {
            return true;
        }
        Activity activity = this.mActivity;
        if (activity != null) {
            this.mQuitting = activity.isFinishing();
        }
        return this.mQuitting;
    }

    public boolean injectEvent(InputEvent inputEvent) {
        return this.injectEvent(inputEvent, 0);
    }

    public boolean injectEvent(InputEvent inputEvent, int n2) {
        if (!R0.d()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent, n2);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyMultiple(int n2, int n3, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyLongPress(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.mGlView.c() ? this.injectEvent((InputEvent)motionEvent) : false;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return !this.mGlView.c() ? this.injectEvent((InputEvent)motionEvent) : false;
    }

    public boolean addViewToPlayer(View view, boolean bl) {
        f0 f02 = bl ? this.mGlView : null;
        this.swapViews(view, (View)f02);
        boolean bl2 = view.getParent() == this;
        bl = bl && this.mGlView.getParent() == null;
        boolean bl3 = this.mGlView.getParent() == this;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                w.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                w.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    public void removeViewFromPlayer(View view) {
        UnityPlayer unityPlayer = this;
        unityPlayer.swapViews((View)unityPlayer.mGlView, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = this.mGlView.getParent() == this;
        if (!(bl && bl2)) {
            if (!bl) {
                w.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                w.Log(6, "removeVireFromPlayer: Failure agging old view to hierarchy");
            }
        }
    }

    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        w.Log(6, stringBuilder.toString());
    }

    public String getNetworkProxySettings(String string) {
        block8: {
            String string2;
            Object object;
            block7: {
                block6: {
                    if (!string.startsWith("http:")) break block6;
                    object = "http.proxyHost";
                    string = "http.proxyPort";
                    string2 = "http.nonProxyHosts";
                    break block7;
                }
                if (!string.startsWith("https:")) break block8;
                object = "https.proxyHost";
                string = "https.proxyPort";
                string2 = "http.nonProxyHosts";
            }
            object = System.getProperties().getProperty((String)object);
            if (object != null && !"".equals(object)) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder((String)object);
                object = System.getProperties().getProperty(string);
                if (object != null && !"".equals(object)) {
                    stringBuilder2.append(":").append((String)object);
                }
                if ((object = System.getProperties().getProperty(string2)) != null && !"".equals(object)) {
                    stringBuilder2.append('\n').append((String)object);
                }
                return stringBuilder2.toString();
            }
            return null;
        }
        return null;
    }

    public boolean startOrientationListener(int n2) {
        A0 a02;
        if (this.mOrientationListener != null) {
            w.Log(5, "Orientation Listener already started.");
            return false;
        }
        A0 a03 = a02;
        UnityPlayer unityPlayer = this;
        this.mOrientationListener = new A0(unityPlayer, unityPlayer.mContext, n2);
        if (a03.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        w.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        OrientationEventListener orientationEventListener = this.mOrientationListener;
        if (orientationEventListener == null) {
            w.Log(5, "Orientation Listener was not started.");
            return false;
        }
        orientationEventListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    public void setMainSurfaceViewAspectRatio(float f2) {
        if (this.mGlView != null) {
            B0 b02;
            B0 b03 = b02;
            b02 = new B0(this, f2);
            this.runOnUiThread(b03);
        }
    }

    public void setScreenBrightness(float f2) {
        f2 = Math.max(0.04f, f2);
        if (this.m_Window != null && this.getScreenBrightness() != f2) {
            C0 c02;
            C0 c03 = c02;
            c02 = new C0(this, f2);
            this.runOnUiThread(c03);
            return;
        }
    }

    public float getScreenBrightness() {
        float f2;
        Window window = this.m_Window;
        if (window == null) {
            return 1.0f;
        }
        float f3 = window.getAttributes().screenBrightness;
        if (f2 < 0.0f) {
            int n2 = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness", (int)255);
            if (PlatformSupport.PIE_SUPPORT) {
                double d2 = (Math.log(n2) * 19.811 - 9.411) / 100.0;
                d2 = Math.min(1.0, d2);
                return (float)Math.max(0.0, d2);
            }
            return (float)n2 / 255.0f;
        }
        return f3;
    }

    public static final class SynchronizationTimeout
    extends Enum {
        public static final /* enum */ SynchronizationTimeout Pause;
        public static final /* enum */ SynchronizationTimeout SurfaceDetach;
        public static final /* enum */ SynchronizationTimeout Destroy;
        private static final /* synthetic */ SynchronizationTimeout[] $VALUES;
        final int value;
        private int m_TimeoutMilliseconds;

        public static SynchronizationTimeout[] values() {
            return (SynchronizationTimeout[])$VALUES.clone();
        }

        public static SynchronizationTimeout valueOf(String string) {
            return Enum.valueOf(SynchronizationTimeout.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private SynchronizationTimeout() {
            void var3_2;
            void var2_-1;
            void var1_-1;
            this.value = var3_2;
            this.m_TimeoutMilliseconds = 2000;
        }

        public static void setTimeoutForAll(int n2) {
            SynchronizationTimeout[] synchronizationTimeoutArray = (SynchronizationTimeout[])SynchronizationTimeout.class.getEnumConstants();
            int n3 = synchronizationTimeoutArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                synchronizationTimeoutArray[i2].setTimeout(n2);
            }
        }

        static {
            SynchronizationTimeout synchronizationTimeout;
            SynchronizationTimeout synchronizationTimeout2;
            SynchronizationTimeout synchronizationTimeout3;
            SynchronizationTimeout synchronizationTimeout4 = synchronizationTimeout3;
            Pause = new SynchronizationTimeout("Pause", 0, 0);
            SynchronizationTimeout synchronizationTimeout5 = synchronizationTimeout2;
            SurfaceDetach = new SynchronizationTimeout("SurfaceDetach", 1, 1);
            SynchronizationTimeout synchronizationTimeout6 = synchronizationTimeout;
            Destroy = new SynchronizationTimeout("Destroy", 2, 2);
            $VALUES = new SynchronizationTimeout[]{synchronizationTimeout4, synchronizationTimeout5, synchronizationTimeout6};
        }

        public void setTimeout(int n2) {
            this.m_TimeoutMilliseconds = n2;
        }

        public int getTimeout() {
            return this.m_TimeoutMilliseconds;
        }
    }
}

