package com.sd.cavphmi.ui.fragment

import android.os.Bundle
import androidx.lifecycle.ViewModelProvider
import androidx.media3.common.AudioAttributes
import androidx.media3.common.MediaItem
import androidx.media3.common.PlaybackException
import androidx.media3.common.Player
import androidx.media3.exoplayer.ExoPlayer
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseFragment
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.databinding.FragmentExoPlayBinding


// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val VIDEO_PARAM1 = "video"
private const val ARG_PARAM2 = "param2"

/**
 *车内视频播放器
 */
class ExoPlayFragment : BaseFragment<FragmentExoPlayBinding, MyBaseViewModel>() {
    private var videoUrl: String = ""
//    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            videoUrl = it.getString(VIDEO_PARAM1, "")
//            param2 = it.getString(ARG_PARAM2)
        }
    }

    override fun getStatuBarColor(): Int {
        return -1
    }


    override fun isAutoStatusBarDarkModeEnable(): Boolean {
        return false
    }

    override fun initContentView(): Int {
        return R.layout.fragment_exo_play
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    override fun onResume() {
        super.onResume()
        binding.playerView.onResume()
    }

    override fun onPause() {
        super.onPause()
        binding.playerView.onPause()
    }

    override fun onStop() {
        super.onStop()
        binding.playerView.onPause()
        releasePlayer()
    }

    override fun onDestroy() {
        super.onDestroy()
        binding.playerView.getAdViewGroup().removeAllViews()
    }

    private lateinit var player: ExoPlayer

    //用于测试，实际可以传参进来
    var videoUri = "https://faw.cuscavp.cn:8443/hdl/live/3.flv"

    override fun initView() {
        initializePlayer()
    }

    fun initializePlayer() {
        val playerBuilder =
            ExoPlayer.Builder(requireContext())
                .setMediaSourceFactory(createMediaSourceFactory())

        player = playerBuilder.build()
        player.addListener(playerEventListener)
        player.setAudioAttributes(AudioAttributes.DEFAULT, /* handleAudioFocus= */ true);
        player.setPlayWhenReady(true)
        binding.playerView.setPlayer(player)

        // Build the media item.
        val mediaItem = MediaItem.Builder()
            .setUri(videoUri)
            .setLiveConfiguration(
                MediaItem.LiveConfiguration.Builder()
                    .setMaxPlaybackSpeed(1.02f)
                    .setMinPlaybackSpeed(0.9f)
                    .build()
            )
            .build()

        player.setMediaItem(mediaItem)
        player.prepare()
        // Start the playback.
//        player.play()
    }


    fun releasePlayer() {
        player.release()
        binding.playerView.setPlayer(/* player= */ null);
    }


    private var playerEventListener=object : Player.Listener{
        override fun onPlayerError(error: PlaybackException) {
            super.onPlayerError(error)
        }
    }


    companion object {
        @JvmStatic
        fun newInstance() = ExoPlayFragment()
/*
        @JvmStatic
        fun newInstance(video: String) =
            ExoPlayFragment().apply {
                arguments = Bundle().apply {
                    putString(VIDEO_PARAM1, video)
                }
            }
*/
    }
}