package com.sd.cavphmi.highmap

import com.ltzw.adasdriver.utils.MyContants

/**
 * 感知物数据
 *
 *  {
 * ptcList: //感知物数组
 * [
 *     {
 *      ptcid:xxx,//感知物id
 *         "lat": 43.826145,		//纬度
 *         "lon": 125.12990,		//经度
 *         "pType":1    //感知物类型 1=车 2=人
 *         "heading": 125.12990,       //航向角
 *          “isRed”:false                  //是否变红
 *          isFlash:fasle                  //是否闪烁
 *          aniTime:1(单位秒)           //此字段具有高优先级，以第一帧接收为准开始计时，控制闪烁和变红在X秒后消失，如果传0已上面的bool值为准。
 *     },
 *
 * }
 */
data class PtcData(
    val ptcList: List<UnityPtc>
)

class UnityPtc {
    //闪烁时间
    var aniTime = 0L
    var pType = 0
    var heading = 0.0
    var isFlash = false
    var isRed = false
    var lat: Double = 0.0
    var lon: Double = 0.0
    var ptcid: String = ""
}
