package com.sd.cavphmi;

import com.sd.cavphmi.utils.Proj4jCoord;

import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

public class UnitTest {


    @Test
    public void calculateProjectionExample2() {
        // 待投影点 (WGS84坐标系)
//        double[] testPoint = {116.3974, 39.9093}; // 北京天安门
//        02
        double[] testPoint = {116.38810256578773,39.92848759523565}; // 北海公园

        // 坐标点串 (02坐标系)
        List<double[]> coordinateSeries = new ArrayList<>();
        coordinateSeries.add(new double[]{116.38811674159075,39.93087909844135});
        coordinateSeries.add(new double[]{116.38513982313117,39.928482159906224});
        coordinateSeries.add(new double[]{116.38808130208565,39.928291923094065});
        coordinateSeries.add(new double[]{116.39202682873122,39.92837661180238});
//        coordinateSeries.add(new double[]{116.38339793653967,39.925386324360574});

        // 计算投影
//        double[] result = CoordinateProjectionUtils.calculatePointProjection(testPoint, coordinateSeries);
        double[] result = Proj4jCoord.INSTANCE.calculatePointProjection(testPoint, coordinateSeries);

        System.out.println("投影点坐标: (" + result[0] + ", " + result[1] + ")");
        System.out.println("最近线段索引: " + (int)result[2]);
        System.out.println("最小距离: " + result[3] + " 米");
    }


}
