package com.sd.cavphmi.websockets

import com.sd.cavphmi.intfaces.OnWebSocketCb
import org.java_websocket.client.WebSocketClient
import org.java_websocket.drafts.Draft
import org.java_websocket.handshake.ServerHandshake
import java.net.Socket
import java.net.URI
import java.nio.ByteBuffer
import java.security.SecureRandom
import java.security.cert.X509Certificate
import javax.net.ssl.SSLContext
import javax.net.ssl.SSLEngine
import javax.net.ssl.SSLSocketFactory
import javax.net.ssl.TrustManager
import javax.net.ssl.X509ExtendedTrustManager

/*****感知目标物**/
class FeelTargetWSClient : BaseWsClient {

    private val TAG = "-----FeelTargetWSClient"

    constructor(serverUri: URI) : super(serverUri){
//        if(serverUri.toString().contains("wss://")){
//            trustAllHosts()
//        }
    }

//    constructor(serverUri: URI?, protocolDraft: Draft?) : super(serverUri, protocolDraft)
//
//    constructor(serverUri: URI?, httpHeaders: MutableMap<String, String>?) : super(
//        serverUri,
//        httpHeaders
//    )

    var onWebSocketCb: OnWebSocketCb? = null

    override fun onOpen(handshakedata: ServerHandshake?) {
        println(TAG + "------- 感知目标物 "+uri.toString())
//        System.out.println(TAG + "new connection opened")
    }

    override fun onMessage(message: String?) {
//        println(TAG + " : " + message)
        if (message.isNullOrEmpty())
            return

        onWebSocketCb?.onMsg(message)
    }

    override fun onMessage(bytes: ByteBuffer?) {
//        System.out.println(TAG + "  received ByteBuffer")

    }

    override fun onClose(code: Int, reason: String?, remote: Boolean) {
        System.out.println(TAG + "  closed with exit code " + code + " additional info: " + reason);
        onWebSocketCb?.onClose(code, reason, remote)
    }

    override fun onError(ex: Exception?) {
        System.err.println(TAG + "an error occurred:" + ex)

    }

//    var onDataCb: OnDataCb? = null
//
//    interface OnDataCb {
//        fun onMsg(str: String)
//    }


}