package com.sd.cavphmi.viewmodels

import android.content.Context
import android.graphics.BitmapFactory
import android.graphics.Point
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.google.gson.Gson
import com.minedata.minenavi.map.Marker
import com.minedata.minenavi.map.MarkerOptions
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.MyLocationStyle
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.map.Polyline
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.mapdal.NativeEnv
import com.minedata.minenavi.mapdal.NdsPoint
import com.minedata.minenavi.util.Tools
import com.sd.cavphmi.R
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.PerceptionBean
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.mock.MRoutes
import com.sd.cavphmi.bean.mock.ParkPath
import com.sd.cavphmi.highmap.AllLine
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.ParkStatu
import com.sd.cavphmi.highmap.ReverCar
import com.sd.cavphmi.highmap.Spinfo
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.MyMapUtils
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import javax.inject.Inject
import kotlin.math.absoluteValue


@HiltViewModel
class MockVM @Inject constructor(
    @ApplicationContext private var context: Context,
) : ViewModel() {

    var mMineMap: MineMap? = null

    private var gson = Gson()

    /**解析网络数据***/
    suspend fun <T> parseDataBean(str: String, clazz: Class<T>): T {
        return withContext(Dispatchers.Default) {
            gson.fromJson(str, clazz)
        }
    }

    /******
     * 模拟车辆位姿
     * @param binding 里的航向角
     * @param binding 里的速度
     * **/
    fun onVehicleMock(
        carVehicle: MutableLiveData<CarVehicle>
    ) {
//        HighMapApi.setCameraAngle(30f)
        viewModelScope.launch {
            var cCar: CarVehicle? = null

            var gson = Gson()
            var str =
                FileIoUtils.getAsset(context, "mock/Car_fangzhen.txt")   //Qgis里取的点和四维取得点混合
            val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)
            //画局部图小车
            drawNavingCar(Tools.latLngToPoint(LatLng(39.81014469509955, 116.50238005214746)))
            //画局部图路径
            smallLineMock(mRoutes)
            //画终点
            addEndMarker(LatLng(39.809039362307594, 116.50254394816011))
            //画出全局路径
            var lines = mRoutes.rs.map {
                AllLine(it[1], it[0])
            }
            HighMapApi.setCarNavPath(lines, showdistance = 200)
            //开启流光效果
            HighMapApi.parkRoundLight("B017")
            //2旁车辆占用
            var spinfos = listOf(Spinfo().apply {
                code = "B016"
                state = true
            }, Spinfo().apply {
                code = "B018"
                state = true
            })
            HighMapApi.setParkStatu(ParkStatu(spinfos))
            //模拟车辆移动
            var head = 0.0
            var oldHead = 0.0
            var bearing = 0f
            mRoutes.rs.forEachIndexed { index, it ->
                if (index > 0 && index < mRoutes.rs.count()) {
                    var p1 = mRoutes.rs.get(index - 1)
                    var pc = mRoutes.rs.get(index)
                    head = MyMapUtils.calculateBearing(
                        LatLng(p1[1], p1[0]),
                        LatLng(pc[1], pc[0])
                    )
                }
                cCar = CarVehicle().apply {
                    var temps = this.vehiclePos?.toMutableList()
                    if ((head - oldHead).absoluteValue < 45) {
                        temps?.set(2, head)
                    }
                    temps?.set(0, it[0])
                    temps?.set(1, it[1])
//                    latitude = it[1]
//                    longitude = it[0]
                }
                oldHead = head

                //更新主车位置
                carVehicle.value = cCar
                //更新小地图小车
                showNavingCarPosition(
                    Tools.latLngToNdsPoint(
                        LatLng(
                            cCar.vehiclePos!!.get(1),
                            cCar.vehiclePos.get(0)
                        )
                    ),
                    cCar.vehiclePos.get(2).toFloat()
                )
                //更新小地图路径
                upSmallLine(index, mRoutes)
                delay(300)
            }
            //消除全局路径
            HighMapApi.setCarNavPath(listOf())
            //删除终点mark
            deleteEndMarker()
            //删除导航小地图小车
//            deleteNavingCar()
            //地锁绘制(升起)
//            var lockStatu = LockStatu().apply {
//                code = "B017"
//                up = false
//            }
//            HighMapApi.setLockStatus(lockStatu)
            //开始泊车
            var parkStr = FileIoUtils.getAsset(context, "mock/parkpath.txt")   //Qgis里取的点和四维取得点混合
            val parkPath = gson.fromJson<ParkPath>(parkStr, ParkPath::class.java)
            //改变镜头角度
            HighMapApi.setCameraAngle(60f)
            HighMapApi.setCameraDistance(30f)
            //前进
            var forword = parkPath.result.routes.find { it.gear == 3 }
            forword?.polyline?.forEach { poly ->
                cCar = CarVehicle().apply {
                    var temps = this.vehiclePos?.toMutableList()
                    temps?.set(0, poly.get(0))
                    temps?.set(1, poly.get(1))
                    temps?.set(2, poly.get(3))
//                    latitude = poly.get(1)
//                    longitude = poly.get(0)
//                    heading = poly.get(3)
                }
                //更新主车位置
                carVehicle.value = cCar
                //更新小地图小车
                showNavingCarPosition(
                    Tools.latLngToNdsPoint(
                        LatLng(
                            cCar.vehiclePos!!.get(1),
                            cCar.vehiclePos.get(0)
                        )
                    ),
                    cCar.vehiclePos.get(2).toFloat()
                )
                delay(300)
            }
            //绘制倒车路径
            var reverCar = ReverCar().apply {
                this.cenLat = 39.80903159
                this.cenLng = 116.50246079
                this.code = "B017"
            }
            HighMapApi.setParkRever(reverCar)
            //改变镜头角度
            HighMapApi.setCameraAngle(90f)
            HighMapApi.setCameraDistance(20f)
            //开始后退
            var fBack = parkPath.result.routes.find { it.gear == 1 }
            fBack?.polyline?.forEach { poly ->
                cCar = CarVehicle().apply {
                    var temps = this.vehiclePos?.toMutableList()
                    temps?.set(0, poly.get(0))
                    temps?.set(1, poly.get(1))
                    temps?.set(2, poly.get(3))
                }
                //更新主车位置
                carVehicle.value = cCar
                //更新小地图小车
                showNavingCarPosition(
                    Tools.latLngToNdsPoint(
                        LatLng(
                            cCar.vehiclePos!!.get(1),
                            cCar.vehiclePos.get(0)
                        )
                    ),
                    cCar.vehiclePos!!.get(1).toFloat()
                )
                delay(300)
            }
            delay(3000)
            //删除导航小地图小车
            deleteNavingCar()
            //关闭流光效果
            HighMapApi.parkRoundLight("")
            //结束泊车
            HighMapApi.setParkComplete(true)
            //降地锁
//            lockStatu.up = false
//            HighMapApi.setLockStatus(lockStatu)
//
        }
    }


    /***跑服务器的模拟数据**/
    fun subVehicle(
        carLiveData: MutableLiveData<CarVehicle>
    ) {
        viewModelScope.launch {
            var gson = Gson()
            var datas = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/CarVehicle_Test.txt", datas)
            datas.forEach { str ->
                val cCar = gson.fromJson<CarVehicle>(str, CarVehicle::class.java)
                if (cCar.vehiclePos != null) {
                    carLiveData.postValue(cCar)
                    delay(200)
                }
            }
        }
    }


    var sPolyline: Polyline? = null

    //点坐标集合
    var sLatLngs: List<LatLng>? = null

    //模拟小地图路径
    private fun smallLineMock(mRoutes: MRoutes) {
        sLatLngs = mRoutes.rs.map {
            LatLng(it[1], it[0])
        }
    }

    //更新小地图路径
    private fun upSmallLine(index: Int, mRoutes: MRoutes) {
        if (sPolyline != null) {
            mMineMap?.removeOverlay(sPolyline)
            sPolyline?.release()
        }
        var temps = sLatLngs?.subList(index, sLatLngs!!.count())
        var nPoints = temps?.map {
            Tools.latLngToNdsPoint(it)
        }?.toTypedArray()

        sPolyline = Polyline(nPoints, false)
        sPolyline?.setStrokeStyle(Overlay.StrokeStyle.solidWithButt)
        sPolyline?.setWidth(8f)
        sPolyline?.setColor(0xFF00B578.toInt())
        mMineMap?.addOverlay(sPolyline)
    }

    //路径规划终点
    private var pEndMarker: Marker? = null

    /**画路径起终点***/
    fun addEndMarker(
        mEndPoint: LatLng
    ) {
        //删除终点marker
        deleteEndMarker()
        val end_icon = BitmapFactory.decodeResource(context.resources, R.drawable.plan_end)
//        var endlatLng = Tools.pointToLatLng(mEndPoint)
        pEndMarker = mMineMap?.addMarker(
            MarkerOptions().zLevel(7).position(mEndPoint).bitmap(end_icon)
        )
    }


    private var mSmallMapCar: MyLocationStyle? = null

    //画小地图小车
    fun drawNavingCar(point: Point) {
        if (mSmallMapCar == null) {
//            mSmallMapCar = MyLocationStyle(R.drawable.angle_blue, true)
            mSmallMapCar = MyLocationStyle("res/icons/carIconInSmallMap.png", true)
            mSmallMapCar?.myLocationType(MyLocationStyle.LOCATION_TYPE_EXTERNAL)
            val scaleFactor = -
            Math.round(((10 * NativeEnv.getDpi() * 2) * 10 / (160 * 48)).toFloat())
                .toFloat() / 10
            mSmallMapCar?.scaleFactor(scaleFactor)
            mSmallMapCar?.anchor(0.5f, 0.5f)
            mSmallMapCar?.setPosition(point)
            mMineMap?.setMyLocationStyle(mSmallMapCar)
        }
    }

    /**
     * 刷新导航中的自车位置
     */
    fun showNavingCarPosition(ndsPoint: NdsPoint?, heading: Float) {
        synchronized(NativeEnv.SyncObject) {
            if (ndsPoint == null) {
                return
            }
            //刷新小地图自车位置
            if (mSmallMapCar != null) {
                var cHeading = 0f - 180f - heading

                mSmallMapCar!!.orientAngle(cHeading)
//                mSmallMapCar!!.orientAngle(heading)
                mSmallMapCar!!.setPositionNds(Tools.ndsPointToLatLng(ndsPoint))
            }
        }
    }

    /**
     * 移除导航小车
     */
    fun deleteNavingCar() {
        if (mMineMap != null && mSmallMapCar != null) {
            mMineMap?.removeOverlay(mSmallMapCar)
            mSmallMapCar!!.release()
            mSmallMapCar = null
        }
    }


    private fun deleteEndMarker() {
        if (pEndMarker != null) {
            mMineMap?.removeMarker(pEndMarker)
            pEndMarker = null
        }
    }


    //感知目标物
    fun onSubTargetMock(targetPre: MutableLiveData<PerceptionBean>) {
        viewModelScope.launch {
            val parts = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/PerTarget.txt", parts)
            parts.forEach { str ->
                var bean = parseDataBean(str, PerceptionBean::class.java)
//                println("------模拟感知目标物数据 = ${bean}")
//                println("------模拟感知目标物typeName = ${bean.typeName}")
//                println("------模拟感知目标物type = ${bean.type}")
//                println("------模拟感知目标物level = ${bean.type}")
                targetPre.value = bean
                delay(2000)
            }
        }
    }

    //v2预警
    fun onV2xMock(targetPre: MutableLiveData<V2xStartBean>) {
        viewModelScope.launch {
            val parts = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/onStartV2x.txt", parts)
            parts.forEach { str ->
                delay(1000)
                var bean = parseDataBean(str, V2xStartBean::class.java)
                println("------模拟感知目标物数据 = ${bean}")
                println("------模拟感知目标物typeName = ${bean.typeName}")
                println("------模拟感知目标物type = ${bean.type}")
                println("------模拟感知目标物level = ${bean.type}")
                targetPre.value = bean
            }
        }
    }

    //全局路径发生切换
    fun onSubLinePlaningMock() {
//        viewModelScope.launch {
//            val alls = mutableListOf<String>()
//            FileIoUtils.getAssetMock(context, "mock/all_line.txt", alls)
//            alls.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, AllLinePlaningBean::class.java)
//                allLine.value = bean
//            }
//        }
    }

    //模拟Http获取全局路径
    /*  suspend fun getLinePlaningMock(vehiclePlate: String): MyResult<ParkLinePlan> {
          return withContext(Dispatchers.IO) {
              val str = FileIoUtils.getAssetContent(context, "find_line.txt")
              val bean =gson.fromJson(str,ParkLinePlan::class.java)
              return@withContext MyResult.Success(bean)
          }
      }*/

    //局部路径
    fun onSubPartLineMock() {
//        viewModelScope.launch {
//            val lines = mutableListOf<String>()
//            lines.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, PartLineBean::class.java)
//                allLine.value = bean
//            }
//        }
    }

    //更新停车位
    fun onPointsMock() {
//        viewModelScope.launch {
//            val points = mutableListOf<String>()
//            FileIoUtils.getAssetMock(context, "mock/change_park.txt", points)
//            points.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, ParkBean::class.java)
//                println("------模拟停车位变更 = ${bean}")
//                parkBean.value = bean
//            }
//        }
    }


}