package com.sd.cavphmi.viewmodels

import android.content.Context
import android.graphics.BitmapFactory
import android.graphics.Point
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.minedata.minenavi.map.Marker
import com.minedata.minenavi.map.MarkerOptions
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.MyLocationStyle
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.map.Polyline
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.mapdal.NativeEnv
import com.minedata.minenavi.util.Tools
import com.sd.cavphmi.R
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.DrivenDecision
import com.sd.cavphmi.bean.EndPoint
import com.sd.cavphmi.bean.Space
import com.sd.cavphmi.highmap.AllLine
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.ReverCar
import com.sd.cavphmi.utils.AvpContants
import com.sd.cavphmi.utils.Proj4jCoord
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import javax.inject.Inject

//地图操作类
@HiltViewModel
class MapOpt @Inject constructor(
    @ApplicationContext private var context: Context
) : ViewModel() {

    var mMineMap: MineMap? = null

    //要右下角地图小车
    private var mSmallMapCar: MyLocationStyle? = null

    //路径规划终点
    private var pEndMarker: Marker? = null

    //小地图路径点坐标集合
    private var sLatLngs: Array<Point>? = null

    // 小地图路径坐标点串 (02坐标系)
    private var coordinateSeries = ArrayList<DoubleArray>()
    private var sPolyline: Polyline? = null

    //是否进入泊车倒车状态
    private var isReversePark = false

    //是否生成小地图线
    var smallMapLine = false

    //全局路径
    private var allLines: List<AllLine>? = null

    //画全局路径
    fun drawAllLines(drivenDecision: DrivenDecision) {
        if (drivenDecision.trajectory.points.count() > 0) {
            //全局路径这里只执行一次
            if (allLines == null || allLines?.count() == 0) {
                allLines = drivenDecision.trajectory.points.map {
                    AllLine().apply {
                        this.lat = it.latitude
                        this.lon = it.longitude
                    }
                }
                HighMapApi.setCarNavPath(allLines!!, drawpassed = true, showdistance = 200)
            }
        }
        var arrived = drivenDecision.trajectory.arrived
        if (arrived) {
//            HighMapApi.setCameraDistance(30f)
//            HighMapApi.setCarNavPath(emptyList())
        }
    }

    //画局部图小车
    fun drawNavingCar(drivenDecision: DrivenDecision) {
        if (mSmallMapCar == null) {
            var point =
                LatLng(drivenDecision.startPoint.latitude, drivenDecision.startPoint.longitude)
            mSmallMapCar = MyLocationStyle("res/icons/carIconInSmallMap.png", true)
            mSmallMapCar?.myLocationType(MyLocationStyle.LOCATION_TYPE_EXTERNAL)
            val scaleFactor = -
            Math.round(((10 * NativeEnv.getDpi() * 2) * 10 / (160 * 48)).toFloat())
                .toFloat() / 10
            mSmallMapCar?.scaleFactor(scaleFactor)
            mSmallMapCar?.anchor(0.5f, 0.5f)
            mSmallMapCar?.setPosition(point)
            mMineMap?.setMyLocationStyle(mSmallMapCar)
        }
    }


    /****根据车辆位置 画局部图小车*/
    fun drawSmallCar(car: CarVehicle) {
        synchronized(this) {
            if (mSmallMapCar == null && car.vehiclePos != null) {
                var point =
                    LatLng(car.vehiclePos.get(1), car.vehiclePos.get(0))
                mSmallMapCar = MyLocationStyle("res/icons/carIconInSmallMap.png", true)
                mSmallMapCar?.myLocationType(MyLocationStyle.LOCATION_TYPE_EXTERNAL)
                val scaleFactor = -
                Math.round(((10 * NativeEnv.getDpi() * 2) * 10 / (160 * 48)).toFloat())
                    .toFloat() / 10
                mSmallMapCar?.scaleFactor(scaleFactor)
                mSmallMapCar?.anchor(0.5f, 0.5f)
                mSmallMapCar?.setPosition(point)
                mMineMap?.setMyLocationStyle(mSmallMapCar)
            }
        }
    }

    /**
     * 刷新右下角小车位置
     */
    fun showNavingCarPosition(carVehicle: CarVehicle) {
        if (carVehicle.vehiclePos == null)
            return
        synchronized(NativeEnv.SyncObject) {
            var ndsLatLng = LatLng(carVehicle.vehiclePos!!.get(1), carVehicle.vehiclePos.get(0))
            var heading = carVehicle.vehiclePos.get(2).toFloat()
            //刷新小地图自车位置
            if (mSmallMapCar != null) {
//                mSmallMapCar!!.orientAngle((heading + 40) % 360)
                mSmallMapCar!!.orientAngle(0f - 180f - heading)
//                mSmallMapCar!!.orientAngle((heading + 180) % 360)
                mSmallMapCar!!.setPositionNds(ndsLatLng)
            }
        }
    }

    /***生成小地图路线 并转化为二维坐标系*/
    fun takeSmallMapLine(drivenDecision: DrivenDecision) {
        if (smallMapLine)
            return
        if (coordinateSeries.count() > 0)
            return
        if (drivenDecision.trajectory.points.count() > 0) {
            smallMapLine = true
            //转换小弟提路径点
            sLatLngs = drivenDecision.trajectory.points.map {
                Tools.latLngToPoint(LatLng(it.latitude, it.longitude))
            }.toTypedArray()
            //生成DoubleArray
            sLatLngs?.forEach {
                var ll = Tools.pointToLatLng(it)
                var temp = doubleArrayOf(ll.longitude, ll.latitude)
                coordinateSeries.add(temp)
            }
        }
    }

    //更新小地图路径
    fun upSmallMapLine(carVehicle: CarVehicle) {
//        deleteSmapLine()
        viewModelScope.launch(Dispatchers.Default) {
            if (coordinateSeries.count() > 0) {
                //当前车辆位置
                var latlng = LatLng(carVehicle.vehiclePos!!.get(1), carVehicle.vehiclePos.get(0))
                //投影计算结果
                var result = Proj4jCoord.calculatePointProjection(
                    doubleArrayOf(latlng.latitude, latlng.longitude),
                    coordinateSeries
                )
//                println("----最近线段索引: " + result[2].toInt())
                var index = result[2].toInt()
                var temps = sLatLngs?.sliceArray(index..sLatLngs!!.lastIndex)

                deleteSmapLine()
//                if (sPolyline == null) {
                sPolyline = Polyline(temps, false)
                sPolyline?.setStrokeStyle(Overlay.StrokeStyle.solidWithButt)
                sPolyline?.setWidth(8f)
                sPolyline?.setColor(0xFF00B578.toInt())
                mMineMap?.addOverlay(sPolyline)
//                }
            }
        }
    }


    /**画路径起终点***/
    fun addEndMarker(endPoint: EndPoint) {
        //删除终点marker
        deleteEndMarker()
        if (pEndMarker == null) {
            var mEndPoint = LatLng(endPoint.latitude, endPoint.longitude)
            val end_icon = BitmapFactory.decodeResource(context.resources, R.drawable.plan_end)
            pEndMarker = mMineMap?.addMarker(
                MarkerOptions().zLevel(7).position(mEndPoint).bitmap(end_icon)
            )
        }
    }


    //判断在泊车状态下的倒挡绘制倒车路线,改变视角
    fun drawReversePark(
        businessType: String,
        businessStatus: String,
        gearType: String,
        space: Space
    ) {
        if (businessType == AvpContants.Park_TYPE) {
            if (businessStatus == AvpContants.TRANSPORT_COMPLETED) {
                HighMapApi.setCameraDistance(30f)
                HighMapApi.setCameraAngle(60f)
            } else if (businessStatus == AvpContants.PARK_PROGRESS) {
                HighMapApi.setCameraDistance(20f)
                HighMapApi.setCameraAngle(90f)

                var reverCar = ReverCar().apply {
                    this.cenLat = space.centerLatitude
                    this.cenLng = space.centerLongitude
                    this.code = space.code
                }
                HighMapApi.setParkRever(reverCar)
            }
//            if (isReversePark)
//                return
//            isReversePark = true
        }
    }


    //是否显示车位流光效果
    fun showParkLight(businessType: String, space: Space) {
        if (businessType == AvpContants.Park_TYPE) {
            HighMapApi.parkRoundLight(space.code)
        } else {
//            HighMapApi.parkRoundLight("")
        }
    }


    //根据AVP状态判特效是否关闭
    fun showEffectAvpStatu(businessType: String, businessStatus: String) {
        //到达召，停车点
        if (businessType == AvpContants.TRANSPORT_COMPLETED || businessType == AvpContants.TRANSPORT_CANCELED || businessType == AvpContants.TRANSPORT_ABNORMAL) {
            HighMapApi.setCarNavPath(emptyList())//消除全局路径
            //删除终点mark
            deleteEndMarker()
            //清除小地图路径数据
            clearSmallLineData()
        }
        //倒车完成
        if (businessType == AvpContants.Park_TYPE) {
            if (businessStatus == AvpContants.PARK_COMPLETED) {
                //消除车位流光特效
                HighMapApi.parkRoundLight("")
                //消除泊车特效
                HighMapApi.setParkComplete(true)
            }
        }
    }


    /**
     * 移除终点
     */
    private fun deleteEndMarker() {
        if (pEndMarker != null) {


            mMineMap?.removeMarker(pEndMarker)
            pEndMarker = null
        }
    }

    /**
     * 移除导航小车
     */
    fun deleteNavingCar() {
        if (mMineMap != null && mSmallMapCar != null) {
            mMineMap?.removeOverlay(mSmallMapCar)
            mSmallMapCar!!.release()
            mSmallMapCar = null
        }
    }

    //删除小地图路径
    fun deleteSmapLine() {
        if (sPolyline != null) {
            mMineMap?.removeOverlay(sPolyline)
            sPolyline?.release()
        }
    }

    //清除小地图路径数据
    fun clearSmallLineData() {
        coordinateSeries.clear()
        sLatLngs?.toMutableList()?.clear()
    }


}