package com.sd.cavphmi.utils

/***AVP 常理**/
object AvpContants {
    //业务类型
    val NIL_TYPE = "NIL"
    val CALL_TYPE = "CALL"
    val Park_TYPE = "Park"

    //档位
    val GEAR_REVERSE = "REVERSE"
    val GEAR_NEUTRAL = "NEUTRAL"
    val GEAR_PARK = "PARK"
    val GEAR_DRIVE = "DRIVE"
    val GEAR_UNKNOWN = "UNKNOWN"

    /***驾驶模式
     *     UNKNOWN(0, "未知"),
     *     AUTOMATIC(1, "自动驾驶"),
     *     MANUAL(2, "人工驾驶"),
     *     REMOTE(3, "远程驾驶");
     * **/
    val DRIVE_MODE_UNKNOWN = "UNKNOWN"
    val DRIVE_MODE_AUTOMATIC = "AUTOMATIC"
    val DRIVE_MODE_MANUAL = "MANUAL"
    val DRIVE_MODE_REMOTE = "REMOTE"

    //业务状态
    /**
     * 运输阶段
     * 泊车有两个阶段 运输阶段(从起点到车位前的倒车入库点)  、停车阶段 (从倒车入库点到车位)，召车只有一个阶段   运输阶段(从车位到终点)
     */
    val TRANSPORT_INIT = "TRANSPORT_INIT"// 运输初始阶段
    val TRANSPORT_SUSPEND = "TRANSPORT_SUSPEND"// 运输初始阶段
    val TRANSPORT_PROGRESS = "TRANSPORT_PROGRESS" // 运输进行中
    val TRANSPORT_WAIT = "TRANSPORT_WAIT" // 运输等待
    val TRANSPORT_RESUMING = "TRANSPORT_RESUMING" // 恢复运输
    val TRANSPORT_COMPLETED = "TRANSPORT_COMPLETED" // 运输完成
    val TRANSPORT_CANCELED = "TRANSPORT_CANCELED"// 取消运输
    val TRANSPORT_ABNORMAL = "TRANSPORT_ABNORMAL" // 运输异常

    /**
     * 停车阶段
     */
    val PARK_INIT = "PARK_INIT" // 泊车初始阶段
    val PARK_SUSPEND = "PARK_SUSPEND" // 泊车阶段挂起
    val PARK_PROGRESS = "PARK_PROGRESS" // 泊车进行中
    val PARK_WAIT = "PARK_WAIT" // 泊车等待
    val PARK_RESUMING = "PARK_RESUMING" // 泊车恢复
    val PARK_COMPLETED = "PARK_COMPLETED" // 泊车完成
    val PARK_CANCELED = "PARK_CANCELED" // 取消泊车
    val PARK_ABNORMAL = "PARK_ABNORMAL"// 泊车异常

    /**
     * 人工接管
     */
    val MANUAL_TAKEOVER_COMPLETED = "MANUAL_TAKEOVER_COMPLETED"

}