package com.sd.cavphmi.ui.view

import android.content.Context
import android.graphics.*
import android.util.AttributeSet
import android.view.View
import android.view.ViewOutlineProvider
import androidx.media3.ui.PlayerView

class RoundedPlayerView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : PlayerView(context, attrs, defStyleAttr) {

    private val path = Path()
    private val rect = RectF()
    private val radius = 16f.dpToPx(context)  // 圆角半径（转换为像素）
    init {
        // 对于 ExoPlayer 3，需要关闭硬件加速或使用其他方式
//        setLayerType(LAYER_TYPE_SOFTWARE, null)
//        updateOutline()
    }

//    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
//        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
//        // 可以在这里根据圆角调整测量逻辑
//        val width = MeasureSpec.getSize(MeasureSpec.AT_MOST)
//        val height = MeasureSpec.getSize(MeasureSpec.AT_MOST)
//
//        setMeasuredDimension(width, height)
//
//        updateOutline()
//    }

    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(w, h, oldw, oldh)
//        updateOutline()
    }


    private fun updateOutline() {
        // 启用轮廓裁剪
        clipToOutline = true
        outlineProvider = object : ViewOutlineProvider() {
            override fun getOutline(view: View, outline: Outline) {
                outline.setRoundRect(0, 0, view.width, view.height, radius)
            }
        }
    }

    // dp 转 px 工具方法
    private fun Float.dpToPx(context: Context): Float {
        return this * context.resources.displayMetrics.density
    }
}
