package com.sd.cavphmi.ui.fragment

import androidx.fragment.app.activityViewModels
import androidx.lifecycle.ViewModelProvider
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseFragment
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.databinding.FragmentCarPanelBinding
import com.sd.cavphmi.utils.AvpContants
import com.sd.cavphmi.viewmodels.CarPanelVM
import com.sd.cavphmi.viewmodels.MainVm
import dagger.hilt.android.AndroidEntryPoint

/**
 * 车仪表
 */
@AndroidEntryPoint
class CarPanelFragment : BaseFragment<FragmentCarPanelBinding, MyBaseViewModel>() {

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun isAutoStatusBarDarkModeEnable(): Boolean {
        return false
    }

    override fun initContentView(): Int {
        return R.layout.fragment_car_panel
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    private val mainVm: MainVm by activityViewModels()
    private val carPanelVM: CarPanelVM by activityViewModels()

    override fun initView() {
        binding.cpBean = carPanelVM.carPanelBean
    }

    override fun initListener() {
        mainVm.carVehicle.observe(this) {
            carPanelVM.setCarPanelBean(it)
        }
        mainVm.avpStatu.observe(this) {
            var dynamic = it.vehicleContext.vehicleDynamic
            //速度
            carPanelVM.carPanelBean.speed.set(dynamic.speed.toInt())
            //驾驶模式
            carPanelVM.carPanelBean.driveMode=dynamic.drivingMode
           //档位
            var gearType = dynamic.gearType
            when (gearType) {
                AvpContants.GEAR_NEUTRAL -> {
                    carPanelVM.carPanelBean.tapPos.set(0)
                }
                AvpContants.GEAR_PARK -> {
                    carPanelVM.carPanelBean.tapPos.set(1)
                }
                AvpContants.GEAR_DRIVE -> {
                    carPanelVM.carPanelBean.tapPos.set(2)
                }
                AvpContants.GEAR_REVERSE -> {
                    carPanelVM.carPanelBean.tapPos.set(3)
                }
                AvpContants.GEAR_UNKNOWN -> {
                    carPanelVM.carPanelBean.tapPos.set(7)
                }
             }
        }
    }


    override fun getToData() {
//        carPanelVM.mock()
    }

    companion object {
        @JvmStatic
        fun newInstance() = CarPanelFragment()
    }

}