package com.sd.cavphmi.repositorys

import com.sd.cavphmi.bean.BindResult
import com.sd.cavphmi.bean.SpaceInfoBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.bean.req.SpaceInfo
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.net.RequestBodyUtil
import com.sd.cavphmi.net.SimpleSSEClient
import com.sd.cavphmi.net.SimpleSSEClient.SSESimpleListener
import com.sd.cavphmi.net.httpmothod.ClientRetrofitMethod
import com.sd.cavphmi.utils.MyContants
import okhttp3.RequestBody
import retrofit2.HttpException
import javax.inject.Inject

/**AVP 接口**/
class AvpDataRepo @Inject constructor(
    private var retrofitMethod: ClientRetrofitMethod
) {

    private var simpleSSEClient = SimpleSSEClient.instance

    /**获取车辆详情
     * @param id 正常应该是传场地ID，但是亦庄这个和太和桥车是一样的
     */
    suspend fun getVehDetail(id: String = ""): MyResult<VehDetailBean> {
//        var map = mapOf("id" to id)
//        var map = mapOf()
        var body = RequestBodyUtil.toRequestBody(mapOf())
        try {
            var bean = retrofitMethod.getVehDetail(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取车位占用情况
     */
    suspend fun getSpaceInfo(): MyResult<SpaceInfoBean> {
        try {
            var spaceInfo = SpaceInfo().apply {
                state = 1
            }
            var body = RequestBodyUtil.toRequestBody(spaceInfo)
            var bean = retrofitMethod.getSpaceInfo(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取可绑车辆
     */
    suspend fun getBindCar(): MyResult<List<BindResult>> {
        try {
//            var body = RequestBodyUtil.toRequestBody(mapOf())
            var bean = retrofitMethod.getBindCar()
            return MyResult.Success(bean.result)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }


    /**登录***/
    suspend fun login(user: String, pwd: String, verifyCode: Int): MyResult<String> {
//        if (id.isNullOrEmpty()) {
//            return MyResult.Error(MyContants.HTTP_ERROR, "error")
//        }
        var map = mapOf("username" to user, "password" to pwd, "verifyCode" to verifyCode)

        var body = RequestBodyUtil.toRequestBody(map)
        try {
            var bean = retrofitMethod.login(body)
            return MyResult.Success(bean.result.token)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取AVP状态信息
     * 我们车辆位姿数据用的是 车俩基础信息的id   可绑车辆接口 返回的是 avp车俩id
     * 所以这里的id 是绑定车辆列表返回的id
     */
    fun getAvpStatus(url: String,body: RequestBody?, listener: SSESimpleListener?) {
        simpleSSEClient.startSSE(
            "${MyContants.HOST}/api/avpweb/hmi/monitor/v1/taskStatus",
            body, listener
        )
    }

    /**获取车辆位姿****/
    fun getCarPose(url: String, body: RequestBody?, listener: SSESimpleListener?) {
//        try {
        simpleSSEClient.startSSE(url, body, listener)
//        } catch (e: HttpException) {
////                println("e.message = ${e.message}")
//        } catch (e: Exception) {
//        }
    }


}