package com.sd.cavphmi.net

import com.sd.cavphmi.bean.WarningBean
import com.sd.cavphmi.moudule.NetworkModule.getSSlSocketFactory
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import okhttp3.Call
import okhttp3.Callback
import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.RequestBody
import okhttp3.Response
import okhttp3.ResponseBody
import okhttp3.internal.closeQuietly
import java.io.IOException
import java.util.concurrent.TimeUnit

class SimpleSSEClient {

    companion object {
        val instance: SimpleSSEClient by lazy { SimpleSSEClient() }
    }
//    private var logging = HttpLoggingInterceptor()

    //    private val client = OkHttpClient()
    private var client: OkHttpClient

    private var responseBodys = mutableListOf<ResponseBody>()
    private var calls = mutableListOf<Call>()

    private constructor() {
        var sslData = getSSlSocketFactory()

        client = OkHttpClient.Builder()
//            .addInterceptor(logging)
            .readTimeout(0, TimeUnit.SECONDS)
            .sslSocketFactory(sslData.socketFactory, sslData.trustAllCert)
            .hostnameVerifier { hostname, session -> true }
            .build()
    }


    fun startSSE(url: String, body: RequestBody?, listener: SSESimpleListener?) {
        val build = Request.Builder()
            .url(url)
            .header("Accept", "text/event-stream")
            .header("Cache-Control", "no-cache")

        if (body != null) {
            build.post(body)
        }
        val request = build.build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                listener?.onError(e)
            }

            override fun onResponse(call: Call, response: Response) {
                if (!response.isSuccessful) {
                    listener?.onError(IOException("HTTP ${response.code} ${response.message}"))
                    return
                }
                calls.add(call)
                try {
                    response.body?.let { body ->
//                    println("----------- let SimpleSSEClient.onResponse")
                        responseBodys.add(body)
                        body.source().use { source ->
                            if (source == null)
                                return
                            listener?.onOpen()

                            while (true) {
                                val line = source.readUtf8Line() ?: break

                                when {
                                    line.startsWith("data:") -> {
                                        val data = line.substring(5).trim()
                                        listener?.onEvent(data)
                                    }

                                    line.isEmpty() -> {
                                        // 事件分隔符
                                    }
                                }
                            }

                            listener?.onClosed()
                        }
                    }
                } catch (e: IOException) {
                    e.printStackTrace()
                } finally {
//                    response.closeQuietly()
                }
            }
        })
    }

    interface SSESimpleListener {
        fun onOpen()
        fun onEvent(data: String)
        fun onError(throwable: Throwable)
        fun onClosed()
    }

    /**释放连接***/
    fun cancelContect() {
        CoroutineScope(Dispatchers.Default).launch {
            for (call in calls) {
                call.cancel()
            }
            calls.clear()
            for (body in responseBodys) {
                body.closeQuietly()
            }
            responseBodys.clear()
        }
    }


}