package com.sd.cavphmi.moudule


import com.sd.cavphmi.net.RetrofitApi.retrofitBuild
import com.sd.cavphmi.net.httpmothod.ClientRetrofitMethod
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import java.security.SecureRandom
import java.security.cert.X509Certificate
import javax.inject.Qualifier
import javax.inject.Singleton
import javax.net.ssl.SSLContext
import javax.net.ssl.SSLSocketFactory
import javax.net.ssl.TrustManager
import javax.net.ssl.X509TrustManager


@Qualifier
@Retention(AnnotationRetention.BINARY)
annotation class OriginOkHttpClient

//@Qualifier
//@Retention(AnnotationRetention.BINARY)
//annotation class AuthInterceptorOkHttpClient

@Qualifier
@Retention(AnnotationRetention.BINARY)
annotation class NormalInterceptorOkHttpClient


@Module
@InstallIn(SingletonComponent::class)
object NetworkModule {

   private var logging = HttpLoggingInterceptor()

    init {
        logging.level = HttpLoggingInterceptor.Level.BODY
    }


    @OriginOkHttpClient
    @Provides
    fun provideOriginOkHttpClient(): OkHttpClient {
        var sslData = getSSlSocketFactory()

        return OkHttpClient.Builder()
            .addInterceptor(logging)
            .sslSocketFactory(sslData.socketFactory, sslData.trustAllCert)
            .hostnameVerifier { hostname, session -> true }
            .build()
    }

    @NormalInterceptorOkHttpClient
    @Provides
    fun provideSeeInterceptorOkHttpClient(
//        headParamsInterceptor: HeadParamsInterceptor
//        baseUrlInterceptor: BaseUrlInterceptor,
    ): OkHttpClient {
        // 创建信任所有证书的 TrustManager
//        val trustAllCerts = arrayOf<TrustManager>(
//            object : X509TrustManager {
//                override fun checkClientTrusted(chain: Array<X509Certificate>, authType: String) {}
//                override fun checkServerTrusted(chain: Array<X509Certificate>, authType: String) {}
//                override fun getAcceptedIssuers(): Array<X509Certificate> = arrayOf()
//            }
//        )
//        // 初始化 SSLContext
//        val sslContext = SSLContext.getInstance("TLS")
//        sslContext.init(null, trustAllCerts, SecureRandom())
        var sslData = getSSlSocketFactory()
        return OkHttpClient.Builder()
//            .addInterceptor(baseUrlInterceptor)
//            .addInterceptor(headParamsInterceptor)
            .addInterceptor(logging)
            .hostnameVerifier { hostname, session -> true }
            .sslSocketFactory(sslData.socketFactory, sslData.trustAllCert)
            .build()
    }

    //------------------API  方法---------------
    @Singleton
    @Provides
    fun provideClientRetrofitService(@OriginOkHttpClient okHttpClient: OkHttpClient): ClientRetrofitMethod {
        return retrofitBuild.client(okHttpClient).build().create(ClientRetrofitMethod::class.java)
    }


//    @Singleton
//    @Provides
//    fun provideClientRetrofitSeeService(@NormalInterceptorOkHttpClient okHttpClient: OkHttpClient): ClientRetrofitMethodSee {
//        return retrofitBuild.client(okHttpClient).build()
//            .create(ClientRetrofitMethodSee::class.java)
//    }


     fun getSSlSocketFactory(): SslData {
        // 创建信任所有证书的 TrustManager
        val trustAllCerts = arrayOf<TrustManager>(
            object : X509TrustManager {
                override fun checkClientTrusted(chain: Array<X509Certificate>, authType: String) {}
                override fun checkServerTrusted(chain: Array<X509Certificate>, authType: String) {}
                override fun getAcceptedIssuers(): Array<X509Certificate> = arrayOf()
            }
        )
        // 初始化 SSLContext
        val sslContext = SSLContext.getInstance("TLS")
        sslContext.init(null, trustAllCerts, SecureRandom())

        return SslData(sslContext.socketFactory, trustAllCerts[0] as X509TrustManager)
    }

    data class SslData(val socketFactory: SSLSocketFactory, var trustAllCert: X509TrustManager)


    // 创建信任所有证书的 SSLSocketFactory
    private fun createSSLSocketFactory(): SSLSocketFactory {
        try {
            val sslContext = SSLContext.getInstance("TLS")
            sslContext.init(null, arrayOf<TrustManager>(object : X509TrustManager {
                override fun checkClientTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?
                ) {
                }

                override fun checkServerTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?
                ) {
                }

                override fun getAcceptedIssuers(): Array<out X509Certificate?>? {
                    return arrayOfNulls(0)
                }

            }), SecureRandom())
            return sslContext.getSocketFactory()
        } catch (e: Exception) {
            throw RuntimeException(e)
        }
    }

}