package com.sd.cavphmi.highmap

import com.google.gson.Gson
import com.unity3d.player.UnityPlayer


/**
 * 高精地图Api
 *
 * 在EarlyWarnVM.kt里setAssEvent函数里用到了
 */
object HighMapApi {

    private var gson = Gson()

    private const val MODELNAME = "MsgBridge"

    /**
     * 给unity读取3d tile json配置
     */
    fun setTileInit(tileJsonBean: TileJsonBean) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetTileInit", gson.toJson(tileJsonBean))
    }

    /**
     * 根据外界传入的坐标，航向角，速度使主车移动
     * @param heading 航向角
     * @param evel 高程
     */
    fun setCarPosition(
        heading: Double,
        lat: Double,
        lon: Double,
        evel: Double,
    ) {
        val carPos = CarPos().apply {
            this.heading = heading
            this.lat = lat
            this.lon = lon
            this.evel = evel
        }
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarPosition", gson.toJson(carPos))
    }

    /**
     * 开启（关闭）绘制主车底盘下的光圈
     */
    fun setCarBottomCircle(isOn: Boolean) {
        var bottomCircle = BottomCircle(isOn)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarBottomCircle", gson.toJson(bottomCircle))
    }

    /**
     * 开启（关闭）主车前方的雷达6个方向
     * 0=关闭  1=左前 2=正前 3=右前   4=右后  5=正后  6=左后
     */
    fun setCarRadarDirection(dirent: Int) {
        var radarDirection = RadarDirection(dirent)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarRadarDirection", gson.toJson(radarDirection))
    }

    /**
     * 车辆行驶全局路径绘制  - 蓝色渐变引导线
     * @param lines 全局路径
     * @param through = "8e959e"     通过路的颜色颜色HEX RRGGBB
     * @param notthrough = "2868D8"    未通过路的颜色颜色HEX RRGGBB
     * @param drawpassed = true    绘制通过路
     * @param showdistance = 45    显示路径的距离，超过这个范围的路径点不绘制
     */
    fun setCarNavPath(
        lines: List<AllLine>,
        notthrough: String = "2868D8",
        through: String = "8e959e",
        drawpassed: Boolean = true,
        showdistance: Int = 45
    ) {
        var carNavPath = CarNavPath().apply {
            this.lines = lines
            this.notthrough = notthrough
            this.through = through
            this.drawpassed = drawpassed
            this.showdistance = showdistance
        }
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarNavPath", gson.toJson(carNavPath))
    }

    /**
     * 传入点的坐标数组绘制路面状况颜色2=(路径里的红色、施工区域红色、人行道红色) 3=绿色（绿波） 4=感知车前的红色）
     * @param alertLins 危险路径
     * @param alertType 危险类型
     */
    fun setAlertPath(alertLine: List<AlertLine>, alertType: Int) {
        var alertPath = AlertPath(alertLine, alertType)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetAlertPath", gson.toJson(alertPath))
    }

    /**
     * 绘制感知物
     * @param ptcList
     */
    fun setPtcData(ptcList: List<UnityPtc>) {
        var ptcData = PtcData(ptcList)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetPtcData", gson.toJson(ptcData))
    }

    /**
     * 感知物预警
     */
    fun setWarnPtc(warnPtc: List<WarnPtc>) {
        UnityPlayer.UnitySendMessage(
            MODELNAME,
            "SetWarnPre",
            gson.toJson(warnPtc)
        )
    }


    /**
     * 设置相机角度
     */
    fun setCameraAngle(angle: Float = 30f) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCameraAngle", "$angle")
    }


    /**
     * 清除所有感知物
     */
    fun clearPtcData() {
        UnityPlayer.UnitySendMessage(MODELNAME, "ClearAllPtcData", "{}")
    }


    /**
     * 选中车位的动效（四周流光效果加一个P的弹跳）
     * @param spaceCode 车位编号
     * 目前测试ID范围：B001~B075
     */
    fun parkRoundLight(spaceCode: String) {
        var parkRoundLight = ParkRoundLight().apply {
            this.spaceCode = spaceCode
        }
        UnityPlayer.UnitySendMessage(MODELNAME, "parkRoundLight", gson.toJson(parkRoundLight))
    }


    //    停车位绘制  - 上面有其他车的状态（传入车辆占用情况绘制）
    fun setParkStatu(parkStatu: ParkStatu) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetSpaceParkStatu", gson.toJson(parkStatu))
    }

    // 正在倒车,计算倒车弧线
    fun setParkRever(reverCar: ReverCar) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetParking", gson.toJson(reverCar))
    }

    // 设置相机距离 如：SendMessage("MsgBridge","SetCameraDistance",10);//设置相机与查看点（车正上方2米）距离10米
    fun setCameraDistance(cDistance: Float) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCameraDistance",  "$cDistance")
    }

    // 泊车完成 用来清除倒车特效
    fun setParkComplete(complete: Boolean) {
        var parkComplete = ParkComplete().apply {
            this.complete = complete
        }
        UnityPlayer.UnitySendMessage(MODELNAME, "SetParkComplete", gson.toJson(parkComplete))
    }

    // 设置地锁状态
    fun setLockStatus(lockStatu: LockStatu) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetLockStatus", gson.toJson(lockStatu))
    }

    // 小地图开关
    fun showMap(showSmallMap: String) {
//    fun showMap(showSmallMap: ShowSmallMap) {
        UnityPlayer.UnitySendMessage(MODELNAME, "showMap", showSmallMap)
//        UnityPlayer.UnitySendMessage(MODELNAME, "showMap", gson.toJson(showSmallMap))
    }


}