package com.sd.cavphmi

import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.platform.app.InstrumentationRegistry
import com.google.gson.Gson
import com.sd.cavphmi.bean.mock.MRoutes
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.Proj4jCoord
import com.sd.cavphmi.utils.SM4CryptoHelper
import kotlinx.coroutines.launch
import kotlinx.coroutines.test.TestScope
import kotlinx.coroutines.test.UnconfinedTestDispatcher
import org.junit.Assert.assertEquals
import org.junit.Test
import org.junit.runner.RunWith

/**
 * Instrumented test, which will execute on an Android device.
 *
 * See [testing documentation](http://d.android.com/tools/testing).
 */
@RunWith(AndroidJUnit4::class)
class ExampleInstrumentedTest {
    @Test
    fun useAppContext() {
        // Context of the app under test.
        val appContext = InstrumentationRegistry.getInstrumentation().targetContext
        assertEquals("com.sd.cavphmi", appContext.packageName)
    }

    @Test
    fun loginCpy() {
        var pwd = "vUO2dStZDhbd*88FfT84"
        var key = "Cusc@itmp-sm4key".toByteArray()
        var pp = SM4CryptoHelper.encryptECB(key, pwd.toByteArray())
        println("------------------pp = ${pp}")
    }

    @Test
    fun calculateTouYing() {
//        02runTest
        TestScope(UnconfinedTestDispatcher()).launch {
            var gson = Gson()
            val appContext = InstrumentationRegistry.getInstrumentation().targetContext
            var str =
                FileIoUtils.getAsset(appContext, "mock/Car_fangzhen.txt")   //Qgis里取的点和四维取得点混合
            val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)

//        val testPoint = doubleArrayOf(116.38810256578773, 39.92848759523565) // 北海公园
            val testPoint = mutableListOf<DoubleArray>()

            // 坐标点串 (02坐标系)
            val coordinateSeries = mutableListOf<DoubleArray>()
            mRoutes.rs.forEachIndexed { index, it ->
                var tLng = it[0]
                var tLag = it[1]
                if (index in 0..50) {
                    tLng = tLng + 0.00001 * index
                    tLag = tLag + 0.00001 * index
                    coordinateSeries.add(doubleArrayOf(tLng, tLag))
                } else {
                    tLng = tLng + 0.000001 * index
                    tLag = tLag - 0.000001 * index
                    coordinateSeries.add(doubleArrayOf(tLng, tLag))
                }
//            coordinateSeries.add(doubleArrayOf(tLng, tLag))
                testPoint.add(doubleArrayOf(it[0], it[1]))
            }
//        coordinateSeries.add(doubleArrayOf(116.38811674159075, 39.93087909844135))
//        coordinateSeries.add(doubleArrayOf(116.38513982313117, 39.928482159906224))
//        coordinateSeries.add(doubleArrayOf(116.38808130208565, 39.928291923094065))
//        coordinateSeries.add(doubleArrayOf(116.39202682873122, 39.92837661180238))

            // 计算投影
//        double[] result = CoordinateProjectionUtils.calculatePointProjection(testPoint, coordinateSeries);
            testPoint.forEachIndexed { index, it ->
                val result = Proj4jCoord.calculatePointProjection(it, coordinateSeries)
                println("车当前下标: (" + index + ") " + "车当前位置：" + it[0] + " " + it[1] + "  最近线段索引: " + result[2].toInt())
//            println("投影点坐标: (" + result[0] + ", " + result[1] + ")")
//            println("最近线段索引: " + result[2].toInt())
                println("最小距离: " + result[3] + " 米")
            }
        }


    }

}