plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    id("dagger.hilt.android.plugin")
    id("kotlin-kapt")
//    id("com.google.protobuf")
//    alias(libs.plugins.proto.google)
}

android {
    namespace = "com.sd.cavphmi"
    compileSdk = 35

    defaultConfig {
        applicationId = "com.sd.cavphmi"
        minSdk = 31
        targetSdk = 35
        versionCode = 1
        versionName = "1.0"

        ndk {
//            abiFilters.addAll(listOf("x86_64", "arm64-v8a"))
            abiFilters.addAll(listOf("arm64-v8a"))
        }

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
        dataBinding = true
        viewBinding = true
    }
    lint {
        abortOnError = false
        checkReleaseBuilds = false
    }
    applicationVariants.all {
        outputs.all {
            if (this is com.android.build.gradle.internal.api.ApkVariantOutputImpl) {
                val config = project.android.defaultConfig
                val versionName = config.versionName
//               val formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HHmm")
//               val createTime = LocalDateTime.now().format(formatter)
                outputFileName = "avp_${versionName}.apk"
            }
        }
    }
}


dependencies {
    implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar", "*.aar"))))
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.activity)
    implementation(libs.androidx.constraintlayout)
//    implementation(libs.androidx.navigation.fragment.ktx)
//    implementation(libs.androidx.navigation.ui.ktx)
    androidTestImplementation("org.jetbrains.kotlinx:kotlinx-coroutines-test:1.10.2")
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    implementation("io.github.cymchad:BaseRecyclerViewAdapterHelper4:4.1.7")
    implementation("com.jakewharton.rxbinding4:rxbinding:4.0.0")
    //屏幕适配
    implementation("com.github.JessYanCoding:AndroidAutoSize:v1.2.1")
    //用于坐标重投影的Proj.4库的Java端口
    implementation("org.locationtech.proj4j:proj4j:1.4.1")
    //sm4 加密
    implementation("org.bouncycastle:bcprov-jdk15on:1.70")

    implementation("com.google.protobuf:protobuf-java:4.31.1")
//    implementation("com.google.protobuf:protobuf-javalite:4.31.1")CRSFactory
//    implementation("com.google.protobuf:protoc:3.0.0")
//    implementation("com.google.protobuf:protobuf-kotlin-lite:4.31.1")

    //播放器
    implementation("androidx.media3:media3-exoplayer:1.8.0")
    implementation("androidx.media3:media3-exoplayer-dash:1.8.0")
    implementation("androidx.media3:media3-ui:1.8.0")
    implementation("androidx.media3:media3-ui-compose:1.8.0")

    //java web socket
    implementation("org.java-websocket:Java-WebSocket:1.6.0")
    //proto
    // Hilt dependencies
    val hilt_version = "2.56.1"
    implementation("com.google.dagger:hilt-android:$hilt_version")
    kapt("com.google.dagger:hilt-android-compiler:${hilt_version}")
    // ViewModel
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.6.2")
    //fragment-ktx
    implementation("androidx.fragment:fragment-ktx:1.8.0")
    // 权限请求框架
    implementation("com.guolindev.permissionx:permissionx:1.8.1")
    //加密库
//    implementation("androidx.security:security-crypto:1.0.0")
//    implementation("com.gyf.immersionbar:immersionbar:2.3.3-beta15")

    //四维依赖
//    implementation("com.jakewharton.timber:timber:4.5.1")
//    implementation("com.mapzen.android:lost:2.1.2")

    //网络
//    implementation("io.reactivex.rxjava3:rxjava:3.0.8")
//    implementation("io.reactivex.rxjava3:rxandroid:3.0.0")

    implementation("com.squareup.retrofit2:retrofit:2.9.0")
    implementation("com.squareup.retrofit2:converter-gson:2.9.0")
//    implementation("com.squareup.retrofit2:adapter-rxjava3:2.9.0")
    implementation("com.squareup.retrofit2:converter-scalars:2.9.0")
    implementation("com.squareup.okhttp3:logging-interceptor:4.9.0")
}