package com.sd.cavphmi.websockets


import org.java_websocket.client.WebSocketClient
import org.java_websocket.drafts.Draft
import org.java_websocket.handshake.ServerHandshake
import protocol.Response
import java.net.URI
import java.nio.ByteBuffer

class MyWebSocketClient : WebSocketClient {

    val TAG = "-----MyWebSocketClient"

    constructor(serverUri: URI?) : super(serverUri)

    constructor(serverUri: URI?, protocolDraft: Draft?) : super(serverUri, protocolDraft)

    constructor(serverUri: URI?, httpHeaders: MutableMap<String, String>?) : super(
        serverUri,
        httpHeaders
    )


    override fun onOpen(handshakedata: ServerHandshake?) {
//        send("Hello, it is me. Mario :)")
        System.out.println(TAG + "new connection opened")
        onSocketCb?.onOpen(handshakedata)
    }

    override fun onMessage(message: String?) {
//        System.out.println(TAG + "received message: " + message);

//        onSocketCb?.onMessage(message)
        //处理各种推送消息
//        let data = {};
//        let result = await decodeResponseProtoBuf(msg);
//        // console.log(result);
//
//        // 抹平与之前推送数据接口的差异
//        data.body = result.data;
//        const eventName = this.dic[result.msgType].action;
//
//        //执行回调
//        // this.messageList[eventName](data);
//        if (this.messageList[eventName]) {
//            //执行回调
//            this.messageList[eventName](data);
//        }
    }

    override fun onMessage(bytes: ByteBuffer?) {
//        System.out.println(TAG + "  received ByteBuffer")
        val socketResponse = Response.SocketResponse.parseFrom(bytes)
        when (socketResponse.msgType) {
            5231 -> {//车辆位姿数据
                onDataCb?.onVehicle(socketResponse)
            }
            5232 -> {//感知目标物数据
                onDataCb?.onTarget(socketResponse)
            }
            5234 -> {//V2X预警开始
                onDataCb?.onStartV2x(socketResponse)
            }
            5235 -> {//V2X预警结束
                onDataCb?.onEndV2x(socketResponse)
            }
            5236 -> {//联网车辆状态数据
                onDataCb?.onVehicleStats(socketResponse)
            }
            1 -> {//停车位变更
                onDataCb?.onPoint(socketResponse)
            }
            52310 -> {//全局路径发生切换
                onDataCb?.onLinePlaning(socketResponse)
            }
            52311 -> {//局部路径
                onDataCb?.onPartLine(socketResponse)
            }
            52312 -> {//rsi事件
                onDataCb?.onRsiEvent(socketResponse)
            }
        }
    }

    override fun onClose(code: Int, reason: String?, remote: Boolean) {
        System.out.println(TAG + "  closed with exit code " + code + " additional info: " + reason);
        onSocketCb?.onClose(code, reason, remote)
    }

    override fun onError(ex: Exception?) {
        System.err.println(TAG + "an error occurred:" + ex);
        onSocketCb?.onError(ex)
    }

    var onSocketCb: OnSocketCb? = null

    interface OnSocketCb {
        fun onOpen(handshakedata: ServerHandshake?)

        //        fun onMessage(message: String?)
//        fun onMessage(socketResponse: Response.SocketResponse)
        fun onClose(code: Int, reason: String?, remote: Boolean)
        fun onError(ex: Exception?)
    }

    var onDataCb: OnDataCb? = null

    interface OnDataCb {
        fun onVehicle(res: Response.SocketResponse)
        fun onVehicleStats(res: Response.SocketResponse)
        fun onTarget(res: Response.SocketResponse)
        fun onStartV2x(res: Response.SocketResponse)
        fun onEndV2x(res: Response.SocketResponse)
        /***停车位变更***/
        fun onPoint(res: Response.SocketResponse)
        fun onLinePlaning(res: Response.SocketResponse)
        fun onPartLine(res: Response.SocketResponse)
        fun onRsiEvent(res: Response.SocketResponse)
    }


}