package com.sd.cavphmi.ui.view

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.LayoutInflater
import android.view.Window
import android.view.WindowManager
import android.widget.LinearLayout
import android.widget.TextView
import com.sd.cavphmi.R

class CustomDialog(context: Context) : Dialog(context) {
    lateinit var  list:List<String>
    init {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT)) // 设置窗口背景透明[6](@ref)
        setContentView(R.layout.dialog_custom)
        setCancelable(false)
        setCanceledOnTouchOutside(false)
        window?.setLayout(
            WindowManager.LayoutParams.MATCH_PARENT,
            WindowManager.LayoutParams.WRAP_CONTENT
        )

        val btnCancel = findViewById<TextView>(R.id.tv_cancle)
        val llCar = findViewById<LinearLayout>(R.id.ll_car)
        for(item in list){
            var carView=LayoutInflater.from(context).inflate(R.layout.item_car,null)
            val tv_car=carView.findViewById<TextView>(R.id.tv_car)
            tv_car.setOnClickListener{
                dismiss()
            }
            llCar.addView(carView)
        }


        btnCancel.setOnClickListener { dismiss() } // 点击取消按钮关闭对话框

    }

    fun setData(data:List<String>){
        this.list=data
    }



}