package com.sd.cavphmi.ui

import android.view.KeyEvent
import android.widget.RelativeLayout
import androidx.activity.viewModels
import androidx.lifecycle.ViewModelProvider
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseActivity
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.databinding.ActivityMainBinding
import com.sd.cavphmi.intfaces.OnConCan
import com.sd.cavphmi.ui.fragment.CarPanelFragment
import com.sd.cavphmi.ui.fragment.ExoPlayFragment
import com.sd.cavphmi.ui.view.CustomDialog
import com.sd.cavphmi.utils.DisplayUtil
import com.sd.cavphmi.viewmodels.MainVm
import com.sd.cavphmi.viewmodels.MockVM
import dagger.hilt.android.AndroidEntryPoint


/**
 * Main activity
 *
 * @constructor Create empty Main activity
 */
@AndroidEntryPoint
class MainActivity : BaseActivity<ActivityMainBinding, MyBaseViewModel>() {

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun initContentView(): Int {
        return R.layout.activity_main
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    //用作模拟
    private val mockVM: MockVM by viewModels()

    private val mainVm: MainVm by viewModels()
//    private val avpMapVM: AvpMapVM by viewModels()

    //退出应用弹窗
    private lateinit var dialogFragment: ExitAppDialog

    //汽车仪表
    private val carPanelFragment by lazy { CarPanelFragment.newInstance() }

    //exo播放器
    private val exoPlayFragment by lazy { ExoPlayFragment.newInstance() }

    override fun initView() {
        mainVm.mockVM = mockVM
        //车辆仪表
        var ft = supportFragmentManager.beginTransaction()
        ft.add(R.id.map_car_pan, carPanelFragment, "1")
        ft.commit()

        //设置视频播放器长和宽
        var height = DisplayUtil.getScreenHeightPx().div(3) - 20
        var width = height.times(2) - 30
        var params = binding.videoFrag.layoutParams as RelativeLayout.LayoutParams
        params.width = width
        params.height = height
        binding.videoFrag.layoutParams = params

        //添加视频播放器，以后看需要控制显示隐藏时机,默认隐藏
        var ft2 = supportFragmentManager.beginTransaction()
        ft2.add(R.id.video_frag, exoPlayFragment, "player")
        ft2.hide(exoPlayFragment)
        ft2.commit()

    }


    override fun getToData() {
        //开启websocket
//        mainVm.startWS()
    }

    override fun initListener() {
        mockBt()
    }

    private fun mockBt() {
        //联网车辆位姿数据
        binding.btVehicle.setOnClickListener {
            mainVm.subVehicle().observe(this) {

            }
        }
        //感知目标物
        binding.btTarget.setOnClickListener {
            mainVm.subTarget()
        }
        //v2x 预警
        binding.btV2x.setOnClickListener {
            mainVm.subStartV2x()
        }
        //模拟选择车辆
        binding.btSetcar.setOnClickListener{
            val dialog=CustomDialog(this)
            var list= listOf("skywell.1ggvlp16.car10","skywell.1ggvlp16.car8")
            dialog.setData(list)
            dialog.show()
        }
    }


    /**
     * Show video play
     * @param isHide false:隐藏 true:显示
     */
    private fun showVideoPlay(isHide: Boolean) {
//        exoPlayFragment.videoUri=""
        var ft = supportFragmentManager.beginTransaction()
        if (isHide) {
            ft.hide(exoPlayFragment)
        } else {
            ft.show(exoPlayFragment)
        }
        ft.commit()
    }


    /* private fun setImage() {
         if(mainVm.v2xStartBean.value.type==1){//前向碰撞
             binding.viewPopuler.setImageResource(R.drawable.advance)
             startPulseAnimation(binding.viewPopuler)
         }else if(mainVm.v2xStartBean.value.type==3){//左转辅助
             binding.viewPopuler.setImageResource(R.drawable.left_icon)
             startPulseAnimation(binding.viewPopuler)
         }else if(mainVm.v2xStartBean.value.type==4){//盲区预警
             binding.viewPopuler.setImageResource(R.drawable.change_lanes)
             startPulseAnimation(binding.viewPopuler)
         }else if(mainVm.v2xStartBean.value.type==6){//紧急制动预警
             binding.viewPopuler.setImageResource(R.drawable.stop_icon)
             startPulseAnimation(binding.viewPopuler)
         }else if(mainVm.v2xStartBean.value.type==12){//弱势交通参与者
             binding.viewPopuler.setImageResource(R.drawable.weak)
             startPulseAnimation(binding.viewPopuler)
         }else{
             binding.viewPopuler.setImageResource(0)
         }
     }*/

    /*    fun startPulseAnimation(imageView: ImageView) {
            val alphaAnim = ObjectAnimator.ofFloat(imageView, "alpha", 1.0f, 0.5f)
            val scaleXAnim = ObjectAnimator.ofFloat(imageView, "scaleX", 1.0f, 1.2f)
            val scaleYAnim = ObjectAnimator.ofFloat(imageView, "scaleY", 1.0f, 1.2f)

            val set = AnimatorSet().apply {
                playTogether(alphaAnim, scaleXAnim, scaleYAnim)
                duration = 300
            }
            set.start()
        }

        private val displayRunnable = object : Runnable {
            override fun run() {
                isPlay = false
            }
        }*/

    override fun dispatchKeyEvent(event: KeyEvent): Boolean {
        if ((event.getKeyCode() == KeyEvent.KEYCODE_BACK) || event.getKeyCode() == KeyEvent.KEYCODE_HOME) {
//            var ft = supportFragmentManager.beginTransaction()
            dialogFragment = ExitAppDialog()
            dialogFragment.onConCan = object : OnConCan {
                override fun onCon() {
                    mainVm.cleanRes()
                    finish()
                }

                override fun onCan() {
                }
            }
            dialogFragment.show(supportFragmentManager, "exit")
            return true
        } else {
            return super.dispatchKeyEvent(event)
        }
    }
}

/*  https://docs.qq.com/sheet/DVWdOYXZXdVVrQWts?tab=xxmysv              socket文档
  https://s.apifox.cn/e355c9e1-cdd1-49ab-acb2-54cfc66b1598/320994000e0  大屏文档
获取AVP状态信息 /v1/avp/overview/listAvpStatus   这个曲华烨要做成socket 的推送形式，通过这个接口获取全局路径和局部路径，车辆业务状态。
        通过里面的vehicleId，调车辆详情（/v1/avp/overview/getVehicleInfo）获取车内视频流，
 websocket 那几个连接，都需要传vehicleId，你也可以不传，不传就是获取所有的*/


//reType 不传就是飞渡，可以问张海胜，数据没有的问题可直接在51word群里反馈

//目前没有全局路径规划变化提醒，具体车位占用情况（用来在车位上绘制白模）

//需求文档里的气泡提醒，数据未必有，已实际数据为准

//【腾讯文档】AVP-HMI接口需求清单
//https://docs.qq.com/sheet/DVmNmZ3VhVEFxRkpV?tab=BB08J2
//高精地图沟通文档
//https://docs.qq.com/sheet/DQWhPRkdteGFNWVZi?tab=BB08J2










