package com.sd.cavphmi.ui

import android.Manifest
import android.content.Intent
import androidx.lifecycle.ViewModelProvider
import com.permissionx.guolindev.PermissionX
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseActivity
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.databinding.ActivityBootBinding
import com.sd.cavphmi.utils.ToastHelper
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class BootActivity : BaseActivity<ActivityBootBinding, MyBaseViewModel>() {

//    private val tcpUpVM: TcpUpVM by viewModels()

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun initContentView(): Int {
        return R.layout.activity_boot
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

//    private var latLngInfo: LatLngInfo? = null

    override fun initView() {
//        tcpUpVM.owner=this
//        tcpUpVM.upWork()
//        viewModel.testWork()
        requestPers()
    }

//    fun getLatLngInfo() {
//        latLngInfo = intent.getParcelableExtra<LatLngInfo>(MyContants.LAT_LNG_INFO)
////        var lat = intent.getDoubleExtra("LAT", 0.0)
////        var lng = intent.getDoubleExtra("LNG", 0.0)
//        println("---------智慧 boot  lng = ${latLngInfo?.lng}  lat = ${latLngInfo?.lat}")
////        println("---------智慧 直接传  lat = $lat   lng = $lng")
//    }

    private fun starMain() {
//        requestPers()
        binding.imageView.postDelayed({
            var jump = Intent(this, MainActivity::class.java)
            startActivity(jump)
            finish()
        }, 10)
    }


    fun requestPers() {
        var list = listOf(
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.ACCESS_FINE_LOCATION,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_PHONE_STATE,
        )
        PermissionX.init(this)
            .permissions(list)
            .onExplainRequestReason { scope, deniedList ->
                scope.showRequestReasonDialog(
                    deniedList,
                    "Adas 需要同意以下授权才能正常使用",
                    "好的",
                    "取消"
                )
            }
//            .onForwardToSettings { scope, deniedList ->
//                scope.showForwardToSettingsDialog(deniedList, "您需要手动在‘设置’中允许必要的权限", "OK", "Cancel")
//            }
            .request { allGranted, grantedList, deniedList ->
                if (allGranted) {
//                    ToastHelper.showShort(this, "All permissions are granted")
                    starMain()
                } else {
                    ToastHelper.showShort(this, "权限被拒")
                    binding.root.postDelayed({
                        finish()
                    }, 500)
                }
            }

    }


}