package com.sd.cavphmi.bean

import androidx.annotation.IntDef
import androidx.databinding.ObservableField


// 使用@IntDef注解这些常量
@IntDef(GearStatus.P, GearStatus.R, GearStatus.N, GearStatus.D)
@Retention(AnnotationRetention.SOURCE)
annotation class GearStatus {
    companion object {
        // 定义状态常量
        const val P = 33
        const val R = 32
        const val N = 34
        const val D = 31
    }
}



/**
 * 车辆仪表
 * */
class CarPanelBean {

    companion object {
        val instance: CarPanelBean by lazy { CarPanelBean() }
    }

    /***CAN 总线数据中的行驶速度，单位：0.01m/s，0xFFFF 表 示缺省***/
    var speed = ObservableField(0)

    /***档位**/
    var tapPos = ObservableField<Int>(GearStatus.P)
    var gear = 0

    //剩余电量
    var remainSoc = ObservableField<Int>(0)

    //转向灯 1=left 2=right
    var lights = 0

    var driveMode = ""

    //航向角0.。360
    var heading = ObservableField<Int>(0)

}